@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Informasi Sekolah</h3>
        @endslot
        <li class="breadcrumb-item">Master</li>
        <li class="breadcrumb-item">Sekolah</li>
        <li class="breadcrumb-item active">Edit</li>
    @endcomponent

    
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                @if (session()->has('sukses'))
                    <div class="alert alert-success" role="alert">
                        {{ session('sukses') }}
                    </div>
                @elseif (session()->has('gagal'))
                    <div class="alert alert-danger" role="alert">
                        {{ session('gagal') }}
                    </div>
                @endif
                <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-6">
                            <h5 class="card-title">{{ $page }}</h5>
                        </div>
                        <div class="col-lg-6">
                            <a href="{{ url($url) }}" class="btn btn-sm btn-primary float-end">Kembali</a>
                        </div>
                    </div>
                </div>
                    {{-- otomatis masuk ke admin/daerah , karena pake resource --}}
                    <form action="{{ url($url)}}/update/{{ $sekolahan->id }}" method="post" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')
                        <div class="card-body">
                            <div class="form-group">
                                <div class="mb-3">
                                    <label class="col-form-label pt-0" for="exampleInputEmail1">Sekolah</label>
                                    <input name="nama" class="form-control" type="text" disabled value="{{ $sekolahan->nama }}">
                                </div>
                                <div class="mb-3">
                                    <label class="col-form-label pt-0" for="exampleInputEmail1">Alamat</label>
                                    <input name="alamat" class="form-control" type="text" value="{{ old('alamat',$sekolahan->alamat) }}">
                                </div>
                                <div class="mb-3">
                                    <label class="col-form-label pt-0" for="exampleInputEmail1">Telp</label>
                                    <input name="telp" class="form-control" type="text" placeholder="Masukkan telp" value="{{ old('telp',$sekolahan->telp) }}">
                                    {{-- penempatan name selalu sebelah input ya, biar gampang di cek --}}
                                </div>
                                <div class="mb-3">
                                    <label class="col-form-label pt-0" for="exampleInputEmail1">Website</label>
                                    <input name="web" class="form-control" type="text" placeholder="Masukkan website" value="{{ old('web',$sekolahan->web) }}">
                                </div>
                                <div class="mb-3">
                                    <label for="image" class="col-form-label pt-0">Logo Sekolah (Format data harus jpg, jpeg, atau png)</label>
                                    <input type="hidden" name="oldImage" value="{{ $sekolahan->logo_gambar }}">
                                    <img id="logo-preview" src="{{ asset('upload/logo_gambar/' . $sekolahan->logo_gambar) ?? '' }}" class="img-preview img-fluid mb-3 col-sm-5 d-block img-90">                                   
                                    <input class="form-control @error('gambar') is-invalid @enderror" type="file" id="logo" name="gambar" accept="image/jpeg, image/png">
                                    @error('gambar')
                                        <div class="invalid-feedback">
                                        {{ $message }}
                                        </div>
                                    @enderror
                                </div>
                                <div class="mb-3">
                                    <label for="image" class="col-form-label pt-0">Kop Surat (Format data harus jpg, jpeg, atau png)</label>
                                    <input type="hidden" name="oldImage" value="{{ $sekolahan->logo }}">
                                    <img id="kop-preview" src="{{ asset('upload/logo_sekolah/' . $sekolahan->logo) ?? '' }}" class="img-preview img-fluid mb-3 col-sm-5 d-block img-90">
                                    <input class="form-control @error('photo') is-invalid @enderror" type="file" id="kop" name="photo" accept="image/jpeg, image/png">
                                    @error('photo')
                                        <div class="invalid-feedback">
                                        {{ $message }}
                                        </div>
                                    @enderror
                                </div>
                                <div class="mb-3">
                                    <label class="col-form-label pt-0" for="exampleInputEmail1">Email</label>
                                    <input name="email" class="form-control" type="email" placeholder="Masukkan Email" value="{{ old('email',$sekolahan->email) }}">
                                </div>
                            </div>
                                <div class="form-group mt-3">
                                    <button type="submit" class="btn btn-primary">Simpan</button>
                                    <button class="btn btn-secondary"><a href="{{ url($url) }}" class="text-white">Cancel</a></button>
                                </div>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
        <script src="{{ asset('assets/js/datatable/datatables/datatable.custom.js') }}"></script>
        <script>
            $(document).ready(function() {
                $('#logo').change(function(event) {
                    var files = event.target.files;
                    if (files && files[0]) {
                        var reader = new FileReader();
                        reader.onload = function(e) {
                            $('#logo-preview').attr('src', e.target.result);
                            $('#logo-preview').show();
                        };
                        reader.readAsDataURL(files[0]);
                    }
                });

                $('#kop').change(function(event) {
                    var files = event.target.files;
                    if (files && files[0]) {
                        var reader = new FileReader();
                        reader.onload = function(e) {
                            $('#kop-preview').attr('src', e.target.result);
                            $('#kop-preview').show();
                        };
                        reader.readAsDataURL(files[0]);
                    }
                });
            });
        </script>
    @endpush

@endsection
