@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/select2.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Halaman</h3>
        @endslot
        <li class="breadcrumb-item">Halaman</li>
        <li class="breadcrumb-item active">List</li>
    @endcomponent

    
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                {{-- Diberikan alert --}}
                @if (session()->has('sukses'))
                    <div class="alert alert-success" role="alert">
                        {{ session('sukses') }}
                    </div>
                @elseif (session()->has('gagal'))
                    <div class="alert alert-danger" role="alert">
                        {{ session('gagal') }}
                    </div>
                @endif

                <div class="card">
                  <div class="card-header">
                    <div class="row">
                        <div class="col-lg-6">
                            <h5 class="card-title">{{ $page }}</h5>
                        </div>
                        <div class="col-lg-6">
                            <a href="{{ url($url) }}" class="btn btn-sm btn-primary float-end">Kembali</a>
                        </div>
                    </div>
                </div>
                    {{-- otomatis masuk ke sekolah/daerah , karena pake resource --}}
                    <form action="{{ url($url) }}/store" method="POST">
                        @csrf
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Pilih Tahun Ajaran</label>
                                <select class="js-example-basic-single" name="idPPeriode" id="idPPeriode">
                                    @foreach ($periode as $p)
                                        @if ($p->id == session()->get('idPPeriode'))
                                            <option value="{{ $p->id }}" selected>{{ $p->nama_periode }}</option>
                                        @else
                                            <option value="{{ $p->id }}">{{ $p->nama_periode }}</option>
                                        @endif
                                    @endforeach
                                </select>
                            </div>
                        </div>
                        <div class="card-footer">
                            <input type="submit" onclick="return confirm('Apakah Anda Yakin? Periode tidak akan bisa diubah lagi')" class="btn btn-primary" value="Simpan">
                            <input type="reset" class="btn btn-secondary" value="Cancel">
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script src="{{ asset('assets/js/select2/select2.full.min.js') }}"></script>
        <script src="{{ asset('assets/js/select2/select2-custom.js') }}"></script>
        <script>
            $(function() {
                let baseUrl     = '{{ url('') }}';
                let idPSekolah = "{{ session()->get('idSekolah') }}";

                $("#idPPeriode").select2({
                    placeholder: "Pilih Tahun Ajaran",
                });
            });
        </script>
    @endpush

@endsection
  
    

