@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Master Daerah</h3>
        @endslot
        <li class="breadcrumb-item">Master</li>
        <li class="breadcrumb-item">Daerah</li>
        <li class="breadcrumb-item active">Edit</li>
    @endcomponent

    
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-6">
                            <h5 class="card-title">{{ $page }}</h5>
                        </div>
                        <div class="col-lg-6">
                            <a href="{{ url($url) }}" class="btn btn-sm btn-primary float-end">Kembali</a>
                        </div>
                    </div>
                </div>
                    <form action="{{ url($url)}}/update" method="post">
                        @csrf
                        @method('PUT')
                        <div class="card-body">
                            <input type="hidden" id="i-nama" class="form-control" name="id" placeholder="Agama" value="{{ $daerah->id }}">
                            <div class="form-group">
                                <label class="col-sm-3 col-form-label">Pilih Provinsi</label>
                                    <select id="select-sem" class="form-select select2" name="idMProvinsi" aria-label="Default select example">
                                        <option value="{{ $daerah->idMProvinsi }}">{{ $daerah->provinsi->nama }}</option>
                                        @foreach ($provinsi as $r) 
                                            <option value="{{ $r->id }}">{{ $r->nama }}</option>
                                        @endforeach
                                    </select >
                            </div>
                            <div class="form-group">
                                <label>Nama Daerah</label>
                                <input type="text" id="i-nama" class="form-control" name="nama" placeholder="Pekerjaan" value="{{ $daerah->nama }}">
                            </div>
                            <div class="form-group mt-3">
                                <button type="submit" class="btn btn-primary">Simpan</button>
                            </div>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
        <script src="{{ asset('assets/js/datatable/datatables/datatable.custom.js') }}"></script>
    @endpush

@endsection
