@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Halaman Detail</h3>
        @endslot
        <li class="breadcrumb-item">Detail</li>
        <li class="breadcrumb-item active">Data</li>
    @endcomponent
<div class="container-fluid pt-4">
                    
    <div class="row justify-content-center">
        <div class="col-lg-10 col-sm-12">
            <div class="card border-top border-0 border-4 border-info">
                <div class="card-header p-3">
                    <div class="row">
                        <div class="col-lg-6">
                            <h5 class="card-title">{{ $page }}</h5>
                        </div>
                        <div class="col-lg-6">
                            <a href="{{ url($url) }}" class="btn btn-sm btn-primary float-end">kembali</a>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <table id="datatable" class="table text-center">
                        <tbody>
                            <tr>
                                <td class="text-sm-end"><b>Nama Siswa</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $tartib->siswa->nama }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Alamat</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $tartib->ortu->alamat }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Kelas</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $tartib->kelaskode->kelas->nama.' '.$tartib->kelaskode->kelas->jurusan->nama.' '.$tartib->kelaskode->nama }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>NISN</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $tartib->siswa->nisn }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Nama Ortu</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $tartib->ortu->nama }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Alamat Ortu</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $tartib->ortu->alamat }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Menghadap Kepada</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $tartib->isian_menghadap }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Tanggal Surat</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $tartib->surat_waktu }}</b></td>
                            </tr>
                            <tr>
                            <tr>
                                <td class="text-sm-end"><b>Guru Konseling</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $tartib->konselor->guru->nama ?? 'Guru Konseling belum di SET' }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>NIP/NIY Guru Konseling</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $tartib->konselor->guru->nip ?? 'Guru Konseling belum di SET' }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Jenis Masalah</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $tartib->isian_jenisMasalah }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Penyelesaian Masalah</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $tartib->isian_penyelesaian }}</b></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="card-footer">
                    <div >
                        <form action="{{ url($url) }}/delete/{{ $tartib->kode_unik }}" method="POST"> @csrf @method('delete')
                            <input type="submit" value="delete" class="btn btn-sm btn-primary float-end" onclick="return confirm('Apakah anda yakin mau hapus ?')">
                        </form>
                        <a href="{{ url("$url/" . $tartib->kode_unik, []) }}/download" class="btn btn-sm btn-primary float-end">unduh</a>
                        <a href="{{ url("$url/" . $tartib->kode_unik, []) }}/edit" class="btn btn-sm btn-primary float-end">edit</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

    @push('scripts')
    @endpush

@endsection