@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/select2.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Halaman</h3>
        @endslot
        <li class="breadcrumb-item">Halaman</li>
        <li class="breadcrumb-item active">List</li>
    @endcomponent

    
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                {{-- Diberikan alert --}}
                @if (session()->has('sukses'))
                    <div class="alert alert-success" role="alert">
                        {{ session('sukses') }}
                    </div>
                @elseif (session()->has('gagal'))
                    <div class="alert alert-danger" role="alert">
                        {{ session('gagal') }}
                    </div>
                @endif
                <div class="card">
                    <div class="card-header p-3">
                        <div class="row">
                            <div class="col-lg-6">
                                <h5 class="card-title">{{ $page }} (Hanya Siswa di Konselor)</h5>
                            </div>
                            <div class="col-lg-6">
                                <a href="{{ url($url) }}/create" class="btn btn-sm btn-primary float-end">Tambah Konseling</a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="mb-3">
                            <label class="col-sm-3 col-form-label">Pilih Kelas</label>
                            <select id="select-kodekelas" class="form-select select2" name="idPKKode" aria-label="Default select example" required>
                                <option value="">Pilih Kelas Terlebih Dahulu</option>
                            </select>
                        </div>
                        <div class="table-responsive" id="tabel-jquery">
                            <table id="isi-tabel" class="table table-striped table-bordered dt-responsive nowrap dataTable no-footer dtr-inline collapsed">
                                <thead >
                                    <tr>
                                        <th data-priority="1" width="50px">No.</th>
                                        <th>NISN</th>
                                        <th>Nama</th>
                                        <th>Jumlah Konseling</th>
                                        <th width="250">Action</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    
                                </tbody>
                            </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
        <script src="{{ asset('assets/js/datatable/datatables/datatable.custom.js') }}"></script>
        <script src="{{ asset('assets/js/select2/select2.full.min.js') }}"></script>
        <script src="{{ asset('assets/js/select2/select2-custom.js') }}"></script>
        <script>
            $("#isi-tabel").DataTable(); // tambahin ini ki

            let baseUrl     = '{{ url('') }}';
        </script>
        @include('admin.filter.kelaskomplit')
        <script>
            $('#select-kodekelas').on('change', function() {
                $("#isi-tabel").DataTable().clear().destroy(); // tambahin ini ki
                
                $('#tabel-jquery').show();
                var idPKKode = $('#select-kodekelas').val();
                // console.log(idPKKode);
                // var val3 = this.value;
                
                $("#isi-tabel").DataTable({
                // $("#tabel-jquery")({
                    language: { // tambahin ini ki
                        emptyTable: "Tidak ada data Siswa",
                        info: "Total: _TOTAL_ Data Siswa",
                        infoEmpty: "Menampilkan 0 dari 0 Data Siswa",
                    },
                    responsive:  true,
                    autoWidth: false,
                    processing: true,
                    ajax: {
                        url: baseUrl+'/siswa/getSiswaKonseling/' +idPKKode,
                        method: 'GET',
                    },
                    dom: 'Bfrtip',
                    buttons: [
                        'copy', 'excel', 'pdf', 'colvis'
                    ]
                });
            });
        </script>
    @endpush

@endsection
