@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/select2.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Halaman Detail</h3>
        @endslot
        <li class="breadcrumb-item">Detail</li>
        <li class="breadcrumb-item active">Data</li>
    @endcomponent
<div class="container-fluid">
        <div class="row">
            {{-- Create RPL --}}
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <div class="col-lg-6">
                            <h5>Data Berita Acara</h5>
                        </div>
                    </div>
                    <form action="{{ url($url) }}/store/{{ $kegiatan->kode_unik }}" method="POST">
                        @csrf 
                        <div class="card-body">
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Tanggal</label>
                                <input name="isian_tanggal" class="form-control" type="date" placeholder="Tanggal dilaksanakan">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Hari</label>
                                <input name="isian_hari" class="form-control" type="text" placeholder="Hari dilaksanakan">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Dilaksanakan</label>
                                <input name="isian_dilaksanakan" class="form-control" type="text" placeholder="nama acara">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Mulai</label>
                                <input name="isian_pukuld" class="form-control" type="time" placeholder="jam mulai">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Selesai</label>
                                <input name="isian_pukuls" class="form-control" type="time" placeholder="jam selelsai">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Tempat Penyelenggara Kegiatan</label>
                                <input name="isian_ruang" class="form-control" type="text" placeholder="tempat diselenggarakan">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Pihak</label>
                                <input name="arrayPihak" class="form-control" type="text" placeholder="pihak">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Kasus</label>
                                <input name="isian_kasus" class="form-control" type="text" placeholder="kasis yang diselesaikan">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Catatan</label>
                                <input name="isian_catatan" class="form-control" type="text" placeholder="catatan">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Solusi</label>
                                <input name="isian_solusi" class="form-control" type="text" placeholder="solusi">
                            </div>
                        </div>
                        <div class="card-footer">
                            <input type="submit" class="btn btn-primary" value="Simpan">
                            <input type="reset" class="btn btn-secondary" value="Cancel">
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
        <script src="{{ asset('assets/js/datatable/datatables/datatable.custom.js') }}"></script>
        <script src="{{ asset('assets/js/editor/ckeditor/ckeditor.js') }}"></script>
        <script src="{{ asset('assets/js/editor/ckeditor/adapters/jquery.js') }}"></script>
        <script src="{{ asset('assets/js/editor/ckeditor/styles.js') }}"></script>
        <script src="{{ asset('assets/js/editor/ckeditor/ckeditor.custom.js') }}"></script>
        <script src="{{ asset('assets/js/select2/select2.full.min.js') }}"></script>
        <script src="{{ asset('assets/js/select2/select2-custom.js') }}"></script>
        <script>
            $("#isi-tabel").DataTable(); // tambahin ini ki

            let baseUrl     = '{{ url('') }}';
            $('#tabel-jquery').hide();
        </script>
        
        @include('admin.filter.kelaskomplit')
        @include('admin.filter.siswaKonselorKelas')
    @endpush

@endsection