@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Halaman Detail</h3>
        @endslot
        <li class="breadcrumb-item">Detail</li>
        <li class="breadcrumb-item active">Data</li>
    @endcomponent
<div class="container-fluid pt-4">
                    
    <div class="row justify-content-center">
        <div class="col-lg-10 col-sm-12">
            <div class="card border-top border-0 border-4 border-info">
                <div class="card-header p-3">
                    <div class="row">
                        <div class="col-lg-6">
                            <h5 class="card-title">{{ $page }}</h5>
                        </div>
                        <div class="col-lg-6">
                            <a href="{{ url($url2) }}/{{ $homevisit_rpl->homevisitkegiatan->kode_unik }}" class="btn btn-sm btn-primary float-end">kembali</a>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <table id="datatable" class="table text-center">
                        <tbody>
                            <tr>
                                <td class="text-sm-end"><b>Ortu</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $homevisit_rpl->ortu->nama }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Konselor</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $homevisit_rpl->konselor->guru->nama ?? 'Konselor belum di SET' }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Tempat</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $homevisit_rpl->surat_tempat }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Tanggal Surat</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $homevisit_rpl->surat_waktu }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Judul</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $homevisit_rpl->isian_judul }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Bidang Bimbingan</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $homevisit_rpl->isian_bidang }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Fungsi Kegiatan</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $homevisit_rpl->isian_fungsi }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Tujuan Kegiatan</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $homevisit_rpl->isian_tujuan }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Hasil yang Ingin Dicapai</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $homevisit_rpl->isian_hasil }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Subyek yang Mengalami Masalah</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $homevisit_rpl->homevisitkegiatan->siswa->nama }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Gambaran Ringkas Masalah</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $homevisit_rpl->isian_gambaran }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Rumah yang Dikunjungi</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $homevisit_rpl->isian_tempat }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Waktu</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $homevisit_rpl->isian_waktu }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Tanggal</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $homevisit_rpl->isian_tanggal }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Semester</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $homevisit_rpl->isian_semester }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Petugas</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $homevisit_rpl->isian_petugas }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Anggota Keluarga yang Dikunjungi</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $homevisit_rpl->isian_anggota }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Keterangan</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $homevisit_rpl->isian_keterangan }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Hasil Pertemuan</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $homevisit_rpl->isian_hasilPertemuan }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Rencana Penilaian</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $homevisit_rpl->isian_rencana }}</b></td>
                            </tr>
                            <tr>
                                <td class="text-sm-end"><b>Catatan Khusus</b></td>
                                <td>:</td>
                                <td class="text-sm-start"><b>{{ $homevisit_rpl->isian_catatan }}</b></td>
                            </tr>
                        </tbody>
                    </table>
                </div>
                <div class="card-footer">
                    <div >
                        <a href="{{ url("$url/" . $homevisit_rpl->id, []) }}/download" class="btn btn-sm btn-primary float-end">unduh</a>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>

    @push('scripts')
    @endpush

@endsection