@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Halaman</h3>
        @endslot
        <li class="breadcrumb-item">Halaman</li>
        <li class="breadcrumb-item active">List</li>
    @endcomponent

    
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                {{-- Diberikan alert --}}
                @if (session()->has('sukses'))
                    <div class="alert alert-success" role="alert">
                        {{ session('sukses') }}
                    </div>
                @elseif (session()->has('gagal'))
                    <div class="alert alert-danger" role="alert">
                        {{ session('gagal') }}
                    </div>
                @endif
                <div class="card">
                    <div class="card-header p-3">
                        <div class="row">
                            <div class="col-lg-6">
                                <h5 class="card-title">{{ $page }} (Hanya Siswa di Konselor)</h5>
                            </div>
                            <div class="col-lg-6">
                                <a href="{{ url($url) }}/create" class="btn btn-sm btn-primary float-end">Tambah Kegiatan Homevisit</a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                        <table class="display" id="basic-1">
                            <thead>
                                <tr>
                                    <th width="50">No.</th>
                                    <th>Kelas</th>
                                    <th>Periode</th>
                                    <th>Siswa</th>
                                    <th>Status</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                {{-- fitur di laravel --}}
                                @foreach ($homevisit_kegiatan as $p)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        {{-- cara panggil kolom nama dari tabel daerah --}}
                                        <td>{{ $p->kelaskode->kelas->nama.' '.$p->kelaskode->kelas->jurusan->nama.' '.$p->kelaskode->nama }}</td>
                                        <td>{{ $p->periode->nama_periode }}</td>
                                        <td>{{ $p->siswa->nama }}</td>
                                        <td>
                                            @if ($p->status == 1)
                                                <span class="outline alert alert-secondary">Dalam Rencana</span>    
                                            @elseif ($p->status == 2)
                                            <span class="outline alert alert-primary">Pengantar</span>
                                            @elseif ($p->status == 3)
                                            <span class="outline alert alert-success">Selesai</span>
                                            @endif
                                        </td>
                                        <td>
                                            <a href="{{ url($url)}}/{{ $p->kode_unik }}" class="btn btn-primary" title="Ubah Data">Detail</a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        </div>
                    </div>
                </div>
                
            </div>
        </div>
    </div>

    @push('scripts')
        <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
        <script src="{{ asset('assets/js/datatable/datatables/datatable.custom.js') }}"></script>
    @endpush

@endsection
