@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Halaman Detail</h3>
        @endslot
        <li class="breadcrumb-item">Detail</li>
        <li class="breadcrumb-item active">Data</li>
    @endcomponent

    <div class="container-fluid pt-4">          
        <div class="row justify-content-center">
            <div class="col-lg-10 col-sm-12">
                <div class="card border-top border-0 border-4 border-info">
                    <div class="card-header p-3">
                        <div class="row">
                            <div class="col-lg-6">
                                <h5 class="card-title">{{ $page }}</h5>
                            </div>
                            <div class="col-lg-6">
                                <a href="{{ url($url2) }}/{{ $homevisit_evaluasi->homevisitkegiatan->kode_unik }}" class="btn btn-sm btn-primary float-end">kembali</a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <table id="datatable" class="table text-center">
                            <tbody>
                                <tr>
                                    <td class="text-sm-end"><b>Topik Permasalahan</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $homevisit_evaluasi->isian_topik }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Bidang Bimbingan</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $homevisit_evaluasi->isian_bidang }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Jenis Layanan</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $homevisit_evaluasi->isian_jenis }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Fungsi Layanan</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $homevisit_evaluasi->isian_fungsi }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Sasaran Layanan</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $homevisit_evaluasi->isian_sasaran }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Kompetensi Dasar</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $homevisit_evaluasi->isian_kompetensi }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Waktu Pelaksanaan</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $homevisit_evaluasi->isian_waktu }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Tempat Pelaksanaan</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $homevisit_evaluasi->isian_tempat }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Cara-cara Penilaian</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $homevisit_evaluasi->isian_penilaiancara }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Penilaian Proses</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $homevisit_evaluasi->isian_penilaianproses }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Deskripsi Hasil Penilaian</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $homevisit_evaluasi->isian_penilaiandeskripsi }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Cara-Cara Analisis</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $homevisit_evaluasi->isian_analisiscara }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Analisis Diagnosis</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $homevisit_evaluasi->isian_analisisdiagnostik }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Analisis Prognosis</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $homevisit_evaluasi->isian_analisisprognosis }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Deskripsi Hasil Analisis</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $homevisit_evaluasi->isian_analisisdeskripsi }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Cara-Cara Tindak Lanjut</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $homevisit_evaluasi->isian_tindaklanjutcara }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Deskripsi Tentang Upaya Tindak Lanjut</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $homevisit_evaluasi->isian_tindaklanjutdeskripsi }}</b></td>
                                </tr>
                                
                            </tbody>
                        </table>
                    </div>
                    <div class="card-footer">
                        <div >
                            <form action="{{ url($url) }}/download" method="POST">
                                @csrf
                                <input type="hidden" name="id" value="{{ $homevisit_evaluasi->id }}"> 
                                <input type="submit" class="btn btn-primary" value="unduh">
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
    @endpush

@endsection