@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Halaman</h3>
        @endslot
        <li class="breadcrumb-item">Halaman</li>
        <li class="breadcrumb-item active">Edit</li>
    @endcomponent

    
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-6">
                            <h5 class="card-title">{{ $page }}</h5>
                            <table>
                                <tr>
                                    <td>Nama</td><td>:</td><td>{{ $ijinKeluar->siswa->nama }}</td>
                                </tr>
                                <tr>
                                    <td>Kelas</td><td>:</td><td> {{ $ijinKeluar->kelasKode->kelas->nama }} {{ $ijinKeluar->kelasKode->jurusan->nama }} {{ $ijinKeluar->kelasKode->nama }} </td>
                                </tr>
                                <tr>
                                    <td>Waktu dibuat</td><td>:</td><td>{{ $ijinKeluar->created_at }}</td>
                                </tr>
                            </table>
                        </div>
                        <div class="col-lg-6">
                            <a href="{{ url($url) }}" class="btn btn-sm btn-primary float-end">Kembali</a>
                        </div>
                    </div>
                </div>
                    <form action="{{ url($url) }}/update/{{ $ijinKeluar->kode_unik }}" method="post">
                        @csrf 
                        @method('PUT')

                        <div class="card-body">
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Yang Terhormat</label>
                                <input name="isian_yth" value="{{ $ijinKeluar->isian_yth }}" class="form-control" type="text" placeholder="Satpam">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Jam</label>
                                <input name="isian_pukul" value="{{ $ijinKeluar->isian_pukul }}" class="form-control digits" type="time" placeholder="Jam">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Tempat</label>
                                <input name="surat_tempat" value="{{ $ijinKeluar->surat_tempat }}" class="form-control" type="text" placeholder="Tempat">
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Tanggal Surat <b>{{ $ijinKeluar->surat_waktu }}</b>, Isi untuk ubah Tanggal Surat</label>
                                <input name="surat_waktu" value="{{ $ijinKeluar->surat_waktu }}" class="form-control" type="date" placeholder="Isi untuk ubah Tanggal Surat">
                            </div>
                            <div class="email-wrapper">
                                <div class="form-group">
                                    <label>Keterangan</label>
                                    <textarea class="form-control" id="text-box" name="isian_keterangan" cols="10" rows="2">{{ $ijinKeluar->isian_keterangan }}</textarea>
                                </div>
                            </div>
                        </div>                
                        <div class="card-footer">
                            <input type="submit" class="btn btn-primary" value="Simpan">
                            <input type="reset" class="btn btn-secondary" value="Cancel">
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script src="{{ asset('assets/js/editor/ckeditor/ckeditor.js') }}"></script>
        <script src="{{ asset('assets/js/editor/ckeditor/adapters/jquery.js') }}"></script>
        <script src="{{ asset('assets/js/editor/ckeditor/styles.js') }}"></script>
        <script src="{{ asset('assets/js/editor/ckeditor/ckeditor.custom.js') }}"></script>
    @endpush

@endsection