@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Halaman Detail</h3>
        @endslot
        <li class="breadcrumb-item">Detail</li>
        <li class="breadcrumb-item active">Data</li>
    @endcomponent

    <div class="container-fluid pt-4">      
        <div class="row justify-content-center">
            <div class="col-lg-10 col-sm-12">
                <div class="card border-top border-0 border-4 border-info">
                    <div class="card-header p-3">
                        <div class="row">
                            <div class="col-lg-6">
                                <h5 class="card-title">{{ $page }}</h5>
                            </div>
                            <div class="col-lg-6">
                                <a href="{{ url($url2) }}/{{ $alihtangan_pengantar->alihkegiatan->kode_unik }}" class="btn btn-sm btn-primary float-end">kembali</a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <table id="datatable" class="table text-center">
                            <tbody>
                                <tr>
                                    <td class="text-sm-end"><b>Nama</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $alihtangan_pengantar->alihkegiatan->siswa->nama }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Kelas</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $alihtangan_pengantar->alihkegiatan->kelaskode->kelas->nama.' '.$alihtangan_pengantar->alihkegiatan->kelaskode->kelas->jurusan->nama.' '.$alihtangan_pengantar->alihkegiatan->kelaskode->nama }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Tempat</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $alihtangan_pengantar->surat_tempat }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Tanggal Surat</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $alihtangan_pengantar->surat_waktu }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Kepada</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $alihtangan_pengantar->isian_yth }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Permasalahan</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $alihtangan_pengantar->isian_permasalahan}}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Keterangan</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $alihtangan_pengantar->isian_keterangan }}</b></td>
                                </tr>
                                
                            </tbody>
                        </table>
                    </div>
                    <div class="card-footer">
                        <div >
                            <form action="{{ url($url) }}/download" method="POST">
                                @csrf
                                <input type="hidden" name="id" value="{{ $alihtangan_pengantar->id }}"> 
                                <input type="submit" class="btn btn-primary" value="unduh">
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
    @endpush

@endsection