@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Halaman Detail</h3>
        @endslot
        <li class="breadcrumb-item">Detail</li>
        <li class="breadcrumb-item active">Data</li>
    @endcomponent

    <div class="row">
        <div class="col-sm-12">
            {{-- Diberikan alert --}}
            @if (session()->has('sukses'))
                <div class="alert alert-success" role="alert">
                    {{ session('sukses') }}
                </div>
            @elseif (session()->has('gagal'))
                <div class="alert alert-danger" role="alert">
                    {{ session('gagal') }}
                </div>
            @endif
            <div class="card">
                <div class="card-header p-3">
                    <div class="row">
                        <div class="col-lg-6">
                            <h5 class="card-title">{{ $page }}</h5>
                        </div>
                    </div>
                </div>
                <div class="card-body">
                    <div class="table-responsive">
                    <table class="display" id="basic-1">
                        <thead>
                            <tr>
                                <th>Siswa</th>
                                <th>Tanggal Surat</th>
                                <th>Catatan</th>
                                <th>Aksi</th>
                            </tr>
                        </thead>
                        <tbody>
                            <tr>
                                <td>{{ $alihtangan_rpl->alihkegiatan->siswa->nama }}</td>
                                <td>{{ $alihtangan_rpl->surat_waktu }}</td>
                                <td>{{ $alihtangan_rpl->isian_catatan }}</td>
                                <td>
                                    <a href="{{ url($url2)}}/{{ $alihtangan_rpl->id }}" class="btn btn-primary" title="Ubah Data">Detail</a>
                                </td>
                            </tr>
                        </tbody>
                    </table>
                    </div>
                </div>
            </div>
                <div class="card">
                    <div class="card-header p-3">
                        <div class="row">
                            <div class="col-lg-6">
                                <h5 class="card-title">Detail Alih Tangan Pengantar</h5>
                            </div>
                            <div class="col-lg-6">
                                @if ($alihtangan_kegiatan['status'] == 1)
                                    <a href="{{ url($url3) }}/create/{{ $alihtangan_kegiatan->id }}" class="btn btn-sm btn-primary float-end">Buat Alih Tangan Pengantar</a>
                                @endif
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                        <table class="display" id="basic-2">
                            <thead>
                                <tr>
                                    <th>Siswa</th>
                                    <th>Kelas</th>
                                    <th>Permasalahan</th>
                                    <th>Aksi</th>
                                </tr>
                            </thead>
                            <tbody>
                                @if ($alihtangan_kegiatan['status'] == 2)
                                    <tr>
                                        <td>{{ $alihtangan_pengantar->alihkegiatan->siswa->nama }}</td>
                                        <td>{{ $alihtangan_pengantar->alihkegiatan->kelaskode->kelas->nama.' '.$alihtangan_pengantar->alihkegiatan->kelaskode->kelas->jurusan->nama.' '.$alihtangan_pengantar->alihkegiatan->kelaskode->nama }}</td>
                                        <td>{{ $alihtangan_pengantar->isian_permasalahan }}</td>
                                        <td>
                                            <a href="{{ url($url3)}}/{{ $alihtangan_pengantar->id }}" class="btn btn-primary" title="Ubah Data">Detail</a>
                                        </td>
                                    </tr>
                                @endif
                            </tbody>
                        </table>
                        </div>
                    </div>
                </div>
        </div>
    </div>

    @push('scripts')
        <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
        <script src="{{ asset('assets/js/datatable/datatables/datatable.custom.js') }}"></script>
    @endpush

@endsection
