@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Halaman</h3>
        @endslot
        <li class="breadcrumb-item">Halaman</li>
        <li class="breadcrumb-item active">List</li>
    @endcomponent

    
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-header">
                        <div class="row">
                            <div class="col-lg-6">
                                <h5 class="card-title">{{ $page }}</h5>
                            </div>
                            <div class="col-lg-6">
                                <a href="{{ url('excel-template/format_input.xlsx') }}" class="btn btn-sm btn-primary float-end">Download Template</a>
                            </div>
                    </div>
                </div>
                </div>
            </div>
            
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row g-2">
                            <div class="col-md-6">
                                <label class="col-form-label">Pilih Agama</label>
                                <select id="select-agama" class="form-select select2" name="idMAgama" aria-label="Default select example" required>
                                    <option value="">Pilih Agama</option>
                                    @foreach ($agama as $r) 
                                        <option value="{{ enc($r->id) }}">{{ $r->nama }}</option>
                                    @endforeach
                                </select >
                            </div>
                            <div class="col-md-6">
                                <label class="col-form-label" for="validationCustomUsername">Copy untuk Excel</label>
                                <input id="enAgama" type="text" class="form-control col-mb-6">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row g-2">
                            <div class="col-md-6">
                                <label class="col-form-label">Pilih Guru Konseling</label>
                                <select id="select-konselor" class="form-select select2" name="idMAgama" aria-label="Default select example" required>
                                    <option value="">Pilih Guru Konseling</option>
                                    @foreach ($konselor as $r) 
                                        <option value="{{ enc($r->guru->id) }}">{{ $r->guru->nama }}</option>
                                    @endforeach
                                </select >
                            </div>
                            <div class="col-md-6">
                                <label class="col-form-label" for="validationCustomUsername">Copy untuk Excel</label>
                                <input id="enKonselor" type="text" class="form-control col-mb-6">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row g-2">
                            <div class="col-md-6">
                                <label class="col-form-label">Tempat Tinggal</label>
                                <select id="select-tempat" class="form-select select2" name="idMAgama" aria-label="Default select example" required>
                                    <option value="">Pilih Tempat Tinggal</option>
                                    @foreach ($tempat as $r) 
                                        <option value="{{ enc($r->id) }}">{{ $r->nama }}</option>
                                    @endforeach
                                </select >
                            </div>
                            <div class="col-md-6">
                                <label class="col-form-label" for="validationCustomUsername">Copy untuk Excel</label>
                                <input id="enTempat" type="text" class="form-control col-mb-6">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row g-2">
                            <div class="col-md-6">
                                <label class="col-form-label">Pekerjaan Orang Tua</label>
                                <select id="select-pekerjaan" class="form-select select2" aria-label="Default select example" required>
                                    <option value="">Pilih Pekerjaan</option>
                                    @foreach ($pekerjaan as $r) 
                                        <option value="{{ enc($r->id) }}">{{ $r->nama }}</option>
                                    @endforeach
                                </select >
                            </div>
                            <div class="col-md-6">
                                <label class="col-form-label" for="validationCustomUsername">Copy untuk Excel</label>
                                <input id="enPekerjaan" type="text" class="form-control col-mb-6">
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            
            <div class="col-sm-12">
                <div class="card">
                    <div class="card-body">
                        <div class="row g-2">
            
                            <form action="{{ url('sekolah/import_siswa') }}" method="POST" enctype="multipart/form-data">
                                @csrf
                                <div class="mb-3 row">
                                    <label class="col-sm-3 col-form-label" for="exampleFormControlTextarea4">Import Excel</label>
                                    <div class="col-sm-9">
                                        <input class="form-control" name="file_excel" type="file" accept=".csv, .xls, .xlsx"> 
                                    </div>
                                </div>    
                                <div>
                                    <div class="text-end btn-mb">
                                        <input type="submit" value="Migrasi" class="btn btn-primary">
                                    </div>
                                </div>
                            </form>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script>
            $(function() {
                let baseUrl     = '{{ url('') }}';
                let idSekolah = "{{ session()->get('idPSekolah') }}";


                $.getJSON(baseUrl+'/api/sekolahkhusus/getjurusansekolah/'+idSekolah, (result) => {
                    if (result.error_code == '0') {
                        let opt = '<option value="">- Pilih Jurusan -</option>';
                        // var dataSem = result.data;
                        // dataSem.sort(function(a, b){
                        //     return a.id_semester - b.id_semester;
                        // });
                        $.each(result.data, function(i, item) {
                            opt += '<option value="'+item.id+'">'+item.nama+'</option>';
                        });
                        $("#select-jurusan").html(opt);
                    }else{
                        let opt = '<option value="">- Tidak Bisa -</option>';
                        $("#select-jurusan").html(opt);
                    }
                    $("#select-jurusan").select2({
                        placeholder: "Pilih Jurusan",
                    });
                });

                $('#select-jurusan').on('change', function() {
                    var val1 = this.value;
                    $.getJSON(baseUrl+'/api/sekolah/getkelassekolah/'+val1, (result) => {
                        if (result.error_code == '0') {
                            let opt = '<option value="">- Pilih Kelas -</option>';
                            // var dataSem = result.data;
                            // dataSem.sort(function(a, b){
                            //     return a.id_semester - b.id_semester;
                            // });
                            $.each(result.data, function(i, item) {
                                opt += '<option value="'+item.id+'">'+item.nama+'</option>';
                            });
                            $("#select-kelas").html(opt);
                        }else{
                            let opt = '<option value="">- Tidak Bisa -</option>';
                            $("#select-kelas").html(opt);
                        }
                        $("#select-kelas").select2({
                            placeholder: "Pilih Kelas",
                        });
                    });
                });

                $('#select-kelas').on('change', function() {
                    var val1 = this.value;
                    $.getJSON(baseUrl+'/api/sekolah/getkelaskodesekolah/'+val1, (result) => {
                        if (result.error_code == '0') {
                            let opt = '<option value="">- Pilih Kode Kelas -</option>';
                            // var dataSem = result.data;
                            // dataSem.sort(function(a, b){
                            //     return a.id_semester - b.id_semester;
                            // });
                            $.each(result.data, function(i, item) {
                                opt += '<option value="'+item.idc+'">'+item.nama+'</option>';
                            });
                            $("#select-kodekelas").html(opt);
                        }else{
                            let opt = '<option value="">- Tidak Bisa -</option>';
                            $("#select-kodekelas").html(opt);
                        }
                        $("#select-kodekelas").select2({
                            placeholder: "Pilih Kode Kelas",
                        });
                    });
                });

                $('#select-kodekelas').on('change', function() {
                    $("#enKelas").val(this.value);
                });

                $('#select-agama').on('change', function() {
                    $("#enAgama").val(this.value);
                });

                $('#select-konselor').on('change', function() {
                    $("#enKonselor").val(this.value);
                });

                $('#select-tempat').on('change', function() {
                    $("#enTempat").val(this.value);
                });

                $('#select-pekerjaan').on('change', function() {
                    $("#enPekerjaan").val(this.value);
                });

            });
        </script>
    @endpush

@endsection


