@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Event</h3>
        @endslot
        <li class="breadcrumb-item">Event</li>
        <li class="breadcrumb-item active">Detail</li>
    @endcomponent

    <div class="container-fluid pt-4">
                        
        <div class="row justify-content-center">
            <div class="col-lg-10 col-sm-12">
                <div class="card border-top border-0 border-4 border-info">
                    <div class="card-header p-3">
                        <div class="row">
                            <div class="col-lg-6">
                                <h5 class="card-title">{{ $page }}</h5>
                            </div>
                            <div class="col-lg-6">
                                <a href="{{ url($url) }}" class="btn btn-sm btn-primary float-end">kembali</a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <table id="datatable" class="table text-center">
                            <tbody>
                                <tr>
                                    <td class="text-sm-center" colspan="3">
                                        <img id="logo-preview" class="img-90" src="{{ asset('upload/image_event/' . $event->image) ?? '-' }}" class="img-preview img-fluid mb-3 col-sm-5 d-block">
                                    </td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Judul</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $event->title }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Waktu Pelaksanaan</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $event->date }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Lokasi</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $event->location }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-end"><b>Status</b></td>
                                    <td>:</td>
                                    <td class="text-sm-start"><b>{{ $event->statusEvent->nama }}</b></td>
                                </tr>
                                <tr>
                                    <td class="text-sm-center" colspan="3">
                                        @if (session()->get('role') == 1)

                                            @if ($event->status == 1)
                                                <form class="form-inline" action="{{ url($url) }}/confirm/{{ $event->id }}" method="POST"> @csrf @method('post')
                                                    <input type="submit" value="Konfirmasi Event" class="btn btn-primary" onclick="return confirm('Apakah Anda Yakin Konfirmasi event {{ $event->nama }} ?')">
                                                </form>
                                                <form class="form-inline" action="{{ url($url) }}/reject-confirm/{{ $event->id }}" method="POST"> @csrf @method('post')
                                                    <input type="submit" value="Tolak Konfirmasi" class="btn btn-warning" onclick="return confirm('Apakah Anda Yakin Tolak Konfirmasi event {{ $event->nama }} ?')">
                                                </form>
                                            @elseif ($event->status == 2)
                                                <form class="form-inline" action="{{ url($url) }}/de-confirm/{{ $event->id }}" method="POST"> @csrf @method('post')
                                                    <input type="submit" value="Batal Konfirmasi" class="btn btn-warning" onclick="return confirm('Apakah Anda Yakin batal Konfirmasi event {{ $event->nama }} ?')">
                                                </form>
                                            @endif

                                        @elseif (session()->get('role') == 2)

                                            <a href="{{ url($url)}}/{{ $event->id }}/edit" class="btn btn-primary" title="Ubah Data">Edit</a>
                                            @if ($event->status == 1 || $event->status == 2 || $event->status == 4)
                                                <a href="{{ url($url)}}/de-aktif/{{ $event->id }}" class="btn btn-primary" title="Non-Aktifkan Data" onclick="return confirm('Apakah Anda Yakin meng non-aktifkan event {{ $event->nama }} ?')">Non Aktifkan</a>
                                            @elseif ($event->status == 3)
                                                <a href="{{ url($url)}}/aktivasi/{{ $event->id }}" class="btn btn-primary" title="Aktifkan Data" onclick="return confirm('Apakah Anda Yakin Aktifkan event {{ $event->nama }} ? Selanjutnya akan menunggu konfirmasi admin kembali')">Aktifkan</a>
                                            @endif
                                            <form class="form-inline" action="{{ url($url) }}/delete/{{ $event->id }}" method="POST"> @csrf @method('delete')
                                                <input type="submit" value="Hapus Event" class="btn btn-danger" onclick="return confirm('Apakah Anda Yakin Hapus event {{ $event->nama }} ?')">
                                            </form>

                                        @endif
                                    </td>
                                </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
    @endpush

@endsection
