@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Event</h3>
        @endslot
        <li class="breadcrumb-item">Event</li>
        <li class="breadcrumb-item active">List</li>
    @endcomponent

    
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                {{-- Diberikan alert --}}
                @if (session()->has('sukses'))
                    <div class="alert alert-success" role="alert">
                        {{ session('sukses') }}
                    </div>
                @elseif (session()->has('gagal'))
                    <div class="alert alert-danger" role="alert">
                        {{ session('gagal') }}
                    </div>
                @endif
                <div class="card">
                    <div class="card-header p-3">
                        <div class="row">
                            <div class="col-lg-6">
                                <h5 class="card-title">{{ $page }}</h5>
                            </div>
                            <div class="col-lg-6">
                                <a href="{{ url($url) }}/create" class="btn btn-sm btn-primary float-end">Tambah Event</a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="table-responsive">
                        <table class="display" id="basic-1">
                            <thead>
                                <tr>
                                    <th width="50">No.</th>
                                    <th>Gambar</th>
                                    <th>Judul</th>
                                    <th>Pelaksanaan</th>
                                    <th>Lokasi</th>
                                    <th>Deskripsi</th>
                                    <th>Status</th>
                                    <th width="100">Action</th>
                                </tr>
                            </thead>
                            <tbody>
                                {{-- fitur di laravel --}}
                                @foreach ($event as $r)
                                    <tr>
                                        <td>{{ $loop->iteration }}</td>
                                        <td> 
                                            <img id="logo-preview" class="img-90" src="{{ asset('upload/image_event/' . $r->image) ?? '' }}" class="img-preview img-fluid mb-3 col-sm-5 d-block">
                                        </td>
                                        <td>{{ $r->title }}</td>
                                        <td>{{ $r->date }}</td>
                                        <td>{{ $r->location }}</td>
                                        <td>{{ $r->description }}</td>
                                        <td>{{ $r->statusEvent->nama }}</td>
                                        <td>
                                            <a href="{{ url($url)}}/{{ $r->id }}" class="btn btn-primary" title="Detail Data">Detail</a>
                                        </td>
                                    </tr>
                                @endforeach
                            </tbody>
                        </table>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
        <script src="{{ asset('assets/js/datatable/datatables/datatable.custom.js') }}"></script>
    @endpush

@endsection
