@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/select2.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/daterange-picker.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Event</h3>
        @endslot
        <li class="breadcrumb-item">Event</li>
        <li class="breadcrumb-item active">Tambah</li>
    @endcomponent

    
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                <div class="card">
                <div class="card-header">
                    <div class="row">
                        <div class="col-lg-6">
                            <h5 class="card-title">{{ $page }}</h5>
                        </div>
                        <div class="col-lg-6">
                            <a href="{{ url($url) }}" class="btn btn-sm btn-primary float-end">Kembali</a>
                        </div>
                    </div>
                </div>
                    {{-- otomatis masuk ke admin/provinsi , karena pake resource --}}
                    <form action="{{ url($url) }}/update/{{ $event->id }}" method="POST" enctype="multipart/form-data">
                        @csrf
                        @method('PUT')

                        <div class="card-body">
                            <div class="mb-3">
                                <label for="image" class="col-form-label pt-0">Gambar Event</label>
                                <img id="gambar-preview" class="img-preview img-fluid mb-3 col-sm-5 d-block img-90" src="{{ asset('upload/image_event/' . $event->image) ?? '' }}">                                 
                                <input name="image" class="form-control @error('image') is-invalid @enderror" type="file" id="gambar">
                                @error('image')
                                    <div class="invalid-feedback">
                                    {{ $message }}
                                    </div>
                                @enderror
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0">Judul Event</label>
                                <input name="title" class="form-control" value="{{ $event->title }}" type="text" placeholder="Masukkan Judul Event" required>
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0">Tanggal Pelaksanaan Event</label>
                                <div class="theme-form">
                                    <div class="form-group">
                                        <input name="daterange2" class="form-control digits" value="{{ $event->date }}" type="text" value="01/01/2024 8:00 AM - 01/01/2024 4:00 PM" required/>
                                    </div>
                                </div>
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Lokasi Event</label>
                                <input name="location" class="form-control" value="{{ $event->location }}" type="text" placeholder="Masukkan Lokasi Event" required>
                            </div>
                            <div class="mb-3">
                                <label class="col-form-label pt-0" for="exampleInputEmail1">Deskripsi Event</label>
                                <textarea name="description" class="form-control" cols="30" rows="10" placeholder="Masukkan Deskripsi Event" required>{{ $event->description }}</textarea>
                            </div>
                        </div>
                        <div class="card-footer">
                            <input type="submit" class="btn btn-primary" value="Perbarui">
                            <input type="reset" class="btn btn-secondary" value="Cancel">
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

@push('scripts')
    <script src="{{ asset('assets/js/datepicker/daterange-picker/moment.min.js') }}"></script>
    <script src="{{ asset('assets/js/datepicker/daterange-picker/daterangepicker.js') }}"></script>
    <script src="{{ asset('assets/js/datepicker/daterange-picker/daterange-picker.custom.js') }}"></script>
    <script>
        $('#gambar').change(function(event) {
            var files = event.target.files;
            if (files && files[0]) {
                var reader = new FileReader();
                reader.onload = function(e) {
                    $('#gambar-preview').attr('src', e.target.result);
                    $('#gambar-preview').show();
                };
                reader.readAsDataURL(files[0]);
            }
        });
    </script>
@endpush

@endsection
