@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Dashboard</h3>
        @endslot
        {{-- <li class="breadcrumb-item">Dashboard</li>
        <li class="breadcrumb-item active">Sample Page</li> --}}
    @endcomponent
    
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                @if (session()->has('sukses'))
                    <div class="alert alert-success" role="alert">
                        {{ session('sukses') }}
                    </div>
                @elseif (session()->has('gagal'))
                    <div class="alert alert-danger" role="alert">
                        {{ session('gagal') }}
                    </div>
                @endif
                <div class="card">
                    <div class="card-header pb-0">
                        <h1 class="text-center mb-5">Petunjuk Penggunaan</h1>
                        <h3>Petunjuk Struktur Kelas</h3>
                        <p>Untuk menyesuaikan Kurikulum 2013 dan Merdeka, Aplikasi yang kami membuat menyesuaikan dengan cara yang Bapak/Ibu bisa ikuti menyesuaikan dengan yang berlaku di sekolah: </p>
                        
                        <div class="mb-5">
                            <h5 class="text-center">Contoh Struktur Kelas Kurikulum 2013</h5>
                            <table class="table text-center" border="1">
                                <thead>
                                    <tr>
                                        <td>No.</td>
                                        <td>Jurusan</td>
                                        <td>Tingkat</td>
                                        <td>Indeks Kelas</td>
                                        <td><b>Dikenal Sebagai</b></td>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>1. </td>
                                        <td>IPA</td>
                                        <td>10</td>
                                        <td>1, 2, 3, 4</td>
                                        <td>10 IPA 1 <br> 10 IPA 2 <br> 10 IPA 3 <br> 10 IPA 4</td>
                                    </tr>
                                    <tr>
                                        <td>2. </td>
                                        <td>Bahasa</td>
                                        <td>11</td>
                                        <td>1, 2</td>
                                        <td>11 Bahasa 1 <br> 11 Bahasa 2</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                        <div class="mb-5">
                            <h5 class="text-center">Contoh Struktur Kelas Kurikulum Merdeka</h5>
                            <table class="table text-center" border="1">
                                <thead>
                                    <tr>
                                        <td>No.</td>
                                        <td>Jurusan</td>
                                        <td>Tingkat</td>
                                        <td>Indeks Kelas</td>
                                        <td><b>Dikenal Sebagai</b></td>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td>1. </td>
                                        <td>Paket 1</td>
                                        <td>10</td>
                                        <td>1, 2, 3, 4</td>
                                        <td>10 Paket 1 1 <br> 10 Paket 1 2 <br> 10 Paket 1 3 <br> 10 Paket 1 4</td>
                                    </tr>
                                    <tr>
                                        <td>2. </td>
                                        <td>Paket</td>
                                        <td>11</td>
                                        <td>1, 2</td>
                                        <td>11 Paket 1 <br> 11 Paket 2</td>
                                    </tr>
                                    <tr>
                                        <td>3. </td>
                                        <td>Paket Kimia</td>
                                        <td>11</td>
                                        <td>1, 2</td>
                                        <td>11 Paket Kimia 1 <br> 11 Paket Kimia 2</td>
                                    </tr>
                                </tbody>
                            </table>
                        </div>
                    </div>
                    <div class="card-body">
                        @if (session()->get('role') == 1)
                            <div class="row">
                                <div class="col-6" id="chartJmlSekolahJenisSekolah" style="height: 500px;"></div>
                                <div class="col-6" id="chartJmlSiswaJenisSekolah" style="height: 500px;"></div>                                
                            </div>
                        @endif
                    </div>
                </div>
            </div>
        </div>
    </div>

    
    @push('scripts')
        <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
        <script>
            let baseUrl     = '{{ url('') }}';
        </script>
        <script type="text/javascript" src="https://www.gstatic.com/charts/loader.js"></script>
        <script type="text/javascript">
            @if (session()->get('role') == 1)
                // Memuat Google Charts
                google.charts.load('current', {'packages':['corechart']});
                google.charts.setOnLoadCallback(drawChartJmlSekolah);
                google.charts.setOnLoadCallback(drawChartJmlSiswa);
            
                function drawChartJmlSekolah() {
                    // Membuat DataTable baru
                    var data = new google.visualization.DataTable();
                    data.addColumn('string', 'Jenis Sekolah');
                    data.addColumn('number', 'Jumlah Sekolah');
            
                    // Panggilan AJAX ke API
                    $.ajax({
                        url: baseUrl+'/chart/jenis-sekolah/getChartJmlSekolah/',
                        method: 'GET',
                        success: function(response) {
                            // Tambahkan data ke chart
                            response.forEach(function(row) {
                                data.addRow([row.jenis, parseInt(row.jumlah)]);
                            });
            
                            // Setelan opsional untuk chart
                            var options = {
                                title: 'Jumlah Sekolah per Jenis Sekolah'
                            };
            
                            // Menggambar chart
                            var chart = new google.visualization.PieChart(document.getElementById('chartJmlSekolahJenisSekolah'));
                            chart.draw(data, options);
                        },
                        error: function(err) {
                            console.log("Error:", err);
                        }
                    });
                }

                function drawChartJmlSiswa() {
                    // Membuat DataTable baru
                    var data = new google.visualization.DataTable();
                    data.addColumn('string', 'Jenis Sekolah');
                    data.addColumn('number', 'Jumlah Siswa');
            
                    // Panggilan AJAX ke API
                    $.ajax({
                        url: baseUrl+'/chart/jenis-sekolah/getChartJmlSiswa/',
                        method: 'GET',
                        success: function(response) {
                            // Tambahkan data ke chart
                            response.forEach(function(row) {
                                data.addRow([row.jenis, parseInt(row.jumlah)]);
                            });
            
                            // Setelan opsional untuk chart
                            var options = {
                                title: 'Jumlah Siswa per Jenis Sekolah'
                            };
            
                            // Menggambar chart
                            var chart = new google.visualization.PieChart(document.getElementById('chartJmlSiswaJenisSekolah'));
                            chart.draw(data, options);
                        },
                        error: function(err) {
                            console.log("Error:", err);
                        }
                    });
                }
            @endif
        </script>
    @endpush

@endsection