@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/select2.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/date-picker.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Master Indeks Kelas</h3>
        @endslot
        <li class="breadcrumb-item">Master</li>
        <li class="breadcrumb-item">Indeks Kelas</li>
        <li class="breadcrumb-item active">Detail</li>
    @endcomponent

    <div class="container-fluid pt-4">
                        
        <div class="row justify-content-center">
            <div class="col-lg-10 col-sm-12">
                <div class="card border-top border-0 border-4 border-info">
                    <div class="card-header p-3">
                        <div class="row">
                            <div class="col-lg-6">
                                <h5 class="card-title">{{ $page }}</h5>
                            </div>
                            <div class="col-lg-6 col-sm-12">
                                <a href="{{ url($url) }}" class="btn btn-sm btn-primary float-end">kembali</a>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">
                        <div class="row">
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Pilih Kelas</label>
                                <select id="select-kodekelas" class="form-select select2" aria-label="Default select example" required>
                                    <option value="">Pilih Kelas Terlebih Dahulu</option>
                                </select>
                            </div>
                        </div>
                        <div class="row">
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Pilih Tanggal</label>
                                <input id="tanggal" class="datepicker-here form-control digits col-sm-9" type="text" data-language="en" placeholder="Isi Tanggal Absensi" />
                            </div>
                        </div>
                        <div class="row">
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Status</label>
                                <input id="status" class="form-control block" type="text" disabled />
                            </div>
                        </div>
                        <div class="row">
                            <div class="table-responsive" id="tabel-jquery">
                                <form action="{{ url($url) }}/store" method="POST">
                                @csrf
                                    <input id="valKelas" type="hidden" name="valKelas">
                                    <input id="valTanggal" type="hidden" name="valTanggal">
                                    <table id="isi-tabel" class="table table-striped table-bordered dt-responsive nowrap dataTable no-footer dtr-inline collapsed">
                                        <thead >
                                            <tr>
                                                <th data-priority="1" width="50px">No.</th>
                                                <th>NISN</th>
                                                <th>Nama</th>
                                                <th width="250">Kehadiran</th>
                                            </tr>
                                        </thead>
                                            
                                            <tbody>
                                                {{-- fitur di laravel --}}
                                                
                                            </tbody>
                                            <tfoot>
                                                <input id="submit" type="submit" class="btn btn-primary"  onclick="return confirm('Apakah anda yakin data sudah benar ?')">
                                                <button class="btn btn-secondary"><a href="{{ url($url) }}" class="text-white">Cancel</a></button>
                                            </tfoot>
                                    </table>
                                </form>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    @push('scripts')
        <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
        <script src="{{ asset('assets/js/datatable/datatables/datatable.custom.js') }}"></script>
        <script src="{{ asset('assets/js/select2/select2.full.min.js') }}"></script>
        <script src="{{ asset('assets/js/select2/select2-custom.js') }}"></script>
        <script src="{{ asset('assets/js/datepicker/date-picker/datepicker.js') }}"></script>
        <script src="{{ asset('assets/js/datepicker/date-picker/datepicker.en.js') }}"></script>
        <script src="{{ asset('assets/js/datepicker/date-picker/datepicker.custom.js') }}"></script>
        <script>
            let baseUrl     = '{{ url('') }}';
            let url     = '{{ $url }}';
            $("#isi-tabel").DataTable();
            $('#tabel-jquery').hide();
        </script>
        @include('admin.filter.kelaskomplit')
        <script>
            $(document).ready(function() {
                let isInitialLoad = true;

                // Inisialisasi Datepicker
                $('#tanggal').datepicker({
                    autoClose: true,
                    language: 'en',
                    dateFormat: 'yyyy-mm-dd',
                    // onSelect: function(formattedDate, date, inst) {
                    //     updateTable(); // Memanggil fungsi updateTable ketika tanggal dipilih
                    // }
                    onSelect: function(formattedDate, date, inst) {
                        if (!isInitialLoad) { // Hanya memanggil updateTable jika bukan load pertama
                            updateTable();
                        }
                    }
                }).data('datepicker').selectDate(new Date('{{ $tanggal }}')); // Set tanggal dari server

                isInitialLoad = false;
                // Menangani perubahan pada dropdown kelas
                $('#select-kodekelas').on('change', function() {
                    updateTable(); // Memanggil fungsi updateTable ketika kelas berubah
                });

                setTimeout(function() {
                    if ('{{ $tanggal }}' && '{{ $idKelas }}') {
                        $('#select-kodekelas').trigger('change');
                    }
                }, 500);

                // Fungsi untuk memperbarui tabel
                function updateTable() {
                    var idPKKode = $('#select-kodekelas').val(); // Mendapatkan ID kelas yang dipilih
                    var selectedDate = $('#tanggal').val(); // Mendapatkan tanggal yang dipilih
                    
                    $('#valKelas').val(idPKKode); // Set hidden input value
                    $('#valTanggal').val(selectedDate); // Set hidden input value
                    
                    console.log('kelas: '+idPKKode)
                    console.log('tanggal: '+selectedDate)

                    if(idPKKode && selectedDate) {
                        $("#isi-tabel").DataTable().clear().destroy(); // Menghancurkan instance DataTable yang ada
                        $('#tabel-jquery').show(); // Menampilkan tabel jika tersembunyi

                        // Membuat instance baru dari DataTable
                        $("#isi-tabel").DataTable({
                            language: {
                                emptyTable: "Tidak ada data Siswa",
                                info: "Total: _TOTAL_ Data Siswa",
                                infoEmpty: "Menampilkan 0 dari 0 Data Siswa",
                            },
                            responsive:  true,
                            autoWidth: false,
                            processing: true,
                            ajax: {
                                url: baseUrl + '/' + url + '/get-absensi-form/' + idPKKode + '/' + selectedDate,
                                method: 'GET',
                                dataSrc: function(json) {
                                    var status = json.status == 1 ? "Absensi sudah dilakukan" : "Belum Absensi";
                                    var submit = json.status == 1 ? "Update" : "Simpan";
                                    if(json.status == 1) {
                                        alert("kelas di Tanggal ini sudah dilakukan absensi ! Klik Update untuk merubah kehadiran");
                                    }
                                    $('#status').val(status);
                                    $('#submit').val(submit);
                                    return json.data;
                                }
                            },
                            columns: [
                                { data: 'i', render: function (data, type, row, meta) { return meta.row + 1; } }, // Menghitung index
                                { data: 'nisn' },
                                { data: 'nama' },
                                { data: 'id', 
                                    render: function(data, type, row, meta) {
                                        // console.log("idSiswa: "+row.id+" | status: "+row.statusAbsensi)
                                        if(row.statusAbsensi == 0 || row.statusAbsensi == 1){
                                            var checkboxChecked = 'checked';
                                        }else{
                                            var checkboxChecked = '';
                                        }

                                        return `<input name="cekId[${data}]" value="${data}" type="hidden">
                                                    <input name="cekVal[${data}]" value="0" type="hidden">
                                                    <input type="checkbox" name="cekVal[${data}]" ${checkboxChecked}>`;
                                    }
                                }
                            ],
                            dom: 'Bfrtip',
                            buttons: [
                                'copy', 'excel', 'pdf', 'colvis'
                            ]
                        });
                    }
                }
            });

        </script>
    @endpush

@endsection
