@extends($admin)

@section('title')
 {{ $title }}
@endsection

@push('css')
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/datatables.css') }}">
    <link rel="stylesheet" type="text/css" href="{{ asset('assets/css/date-picker.css') }}">
@endpush

@section('content')
    @component('components.breadcrumb')
        @slot('breadcrumb_title')
        <h3>Akademik</h3>
        @endslot
        <li class="breadcrumb-item">Absensi</li>
        <li class="breadcrumb-item active">Siswa</li>
    @endcomponent

    
    <div class="container-fluid">
        <div class="row">
            <div class="col-sm-12">
                {{-- Diberikan alert --}}
                @if (session()->has('sukses'))
                    <div class="alert alert-success" role="alert">
                        {{ session('sukses') }}
                    </div>
                @elseif (session()->has('gagal'))
                    <div class="alert alert-danger" role="alert">
                        {{ session('gagal') }}
                    </div>
                @endif
                <div class="card">
                    <div class="card-header p-3">
                        <div class="row">
                            <div class="col-lg-6">
                                <h5 class="card-title">{{ $page }}</h5>
                            </div>
                        </div>
                    </div>
                    <div class="card-body">

                        <div class="row">
                            <div class="mb-3">
                                <label class="col-sm-3 col-form-label">Pilih Tanggal</label>
                                <input id="tanggal" class="datepicker-here form-control digits col-sm-9" type="text" data-language="en" placeholder="Isi Tanggal Absensi"/>
                                {{-- <a href="{{ url($url) }}/create" class="btn btn-sm btn-primary float-end m-4" id="linkTambahAbsensi">Tambah Absensi</a> --}}
                            </div>
                        </div>
                        <div class="row">
                            <div class="table-responsive" id="tabel-jquery">
                                <table id="isi-tabel" class="table table-striped table-bordered dt-responsive nowrap dataTable no-footer dtr-inline collapsed">
                                    <thead>
                                        <tr>
                                            <th>Tanggal</th>
                                            <th>Kelas</th>
                                            <th>Jumlah Hadir</th>
                                            <th>Jumlah tidak Hadir</th>
                                            <th>Absensi</th>
                                            <th>Aksi</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        {{-- fitur di laravel --}}
                                        
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

        </div>
    </div>

    @push('scripts')
        <script src="{{ asset('assets/js/datatable/datatables/jquery.dataTables.min.js') }}"></script>
        <script src="{{ asset('assets/js/datatable/datatables/datatable.custom.js') }}"></script>
        <script src="{{ asset('assets/js/datepicker/date-picker/datepicker.js') }}"></script>
        <script src="{{ asset('assets/js/datepicker/date-picker/datepicker.en.js') }}"></script>
        <script src="{{ asset('assets/js/datepicker/date-picker/datepicker.custom.js') }}"></script>
        <script>
            let baseUrlUrl     = '{{ url($url) }}';

            $("#isi-tabel").DataTable();
            $('#tabel-jquery').hide();
        </script>
        <script>
            $(document).ready(function() {

                // dikasih notif kalo tanggal ini tidak ada absensi
                
                $('.datepicker-here').datepicker({
                    autoClose: true, // Pastikan date picker tertutup setelah tanggal dipilih
                    language: 'en', // Mengatur bahasa
                    onSelect: function(formattedDate, date, inst) {
                        var formattedForURL = date.getFullYear() + '-' + (date.getMonth() + 1).toString().padStart(2, '0') + '-' + date.getDate().toString().padStart(2, '0');
                        updateDataTable(formattedForURL);  // Update dengan format YYYY-MM-DD
                    }

                });

                function updateDataTable(tanggal) {
                    console.log(tanggal)
                    $("#isi-tabel").DataTable().clear().destroy();
                    $('#tabel-jquery').show();
                    $('#linkTambahAbsensi').attr('href', "{{ url($url) }}/create/" + tanggal);
                   

                    $("#isi-tabel").DataTable({
                        language: {
                            emptyTable: "Tidak ada data Siswa",
                            info: "Total: _TOTAL_ Data Siswa",
                            infoEmpty: "Menampilkan 0 dari 0 Data Siswa",
                        },
                        responsive:  true,
                        autoWidth: false,
                        processing: true,
                        ajax: {
                            url: baseUrlUrl + '/get-absensi/' + tanggal,
                            method: 'GET',
                        },
                        dom: 'Bfrtip',
                        buttons: [
                            'copy', 'excel', 'pdf', 'colvis'
                        ]
                    });
                }
            });

            </script>            
    @endpush

@endsection
