<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

// Library
use DB;
use Illuminate\Database\Eloquent\SoftDeletes;

class MKorKonselorModel extends Model
{
    // softdelete itu untuk fitur dari laravel. User hapus, data untuk user hilang tapi di tabel tidak hilang. cuma di hiden
    use HasFactory, SoftDeletes;

    // Nama tabel
    protected $table = 'sekolah_korkonselor';
    protected $guarded = ['id'];

    public function kelaskode()
    {
        return $this->belongsTo(MPerpusKelasKodeModel::class, 'idPKKode', 'id');
    }
    public function sekolah()
    {
        return $this->belongsTo(MPerpusSekolahModel::class, 'idPSekolah', 'id');
    }
    public function guru()
    {
        return $this->belongsTo(MPerpusSekolahModel::class, 'idSGuru', 'id');
    }
}
