<?php

namespace App\Models\Stakeholder;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

// Library
use DB;
use Illuminate\Database\Eloquent\SoftDeletes;

class SekolahWaliModel extends Model
{
    // softdelete itu untuk fitur dari laravel. User hapus, data untuk user hilang tapi di tabel tidak hilang. cuma di hiden
    use HasFactory, SoftDeletes;

    // Nama tabel
    protected $table = 'sekolah_wali';
    protected $guarded = ['id'];

    public function sekolah()
    {
        return $this->belongsTo(\App\Models\Perpus\SekolahModel::class, 'idPSekolah', 'id');
    }

    public function kelas()
    {
        return $this->belongsTo(\App\Models\Perpus\KelasModel::class, 'idPKelas', 'id');
    }

    public function kelaskode()
    {
        return $this->belongsTo(\App\Models\Perpus\KelasKodeModel::class, 'idPKKode', 'id');
    }

    public function guru()
    {
        return $this->belongsTo(GuruModel::class, 'idSGuru', 'id')->withDefault();
    }
}
