<?php

namespace App\Models\Stakeholder;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

// Library
use DB;
use Illuminate\Database\Eloquent\SoftDeletes;

class GuruModel extends Model
{
    // softdelete itu untuk fitur dari laravel. User hapus, data untuk user hilang tapi di tabel tidak hilang. cuma di hiden
    use HasFactory, SoftDeletes;

    // Nama tabel
    protected $table = 'sekolah_guru';
    protected $guarded = ['id'];

    public function sekolah()
    {
        return $this->belongsTo(\App\Models\Perpus\SekolahModel::class, 'idPSekolah', 'id');
    }

    public function kelas()
    {
        return $this->belongsTo(\App\Models\Perpus\sKelasModel::class, 'idPKelas', 'id');
    }

    public function kelaskode()
    {
        return $this->belongsTo(\App\Models\Perpus\KelasKodeModel::class, 'idPKKode', 'id');
    }

    public function guru()
    {
        return $this->belongsTo(GuruModel::class, 'idSGuru', 'id')->withDefault();
    }

    public function mapel()
    {
        return $this->belongsTo(\App\Models\Master\MapelGuruModel::class, 'idMapel', 'id');
    }

    public function sekolah_wali()
    {
        return $this->belongsTo(SekolahWaliModel::class, 'idPKKode', 'id');
    }
}
