<?php

namespace App\Models\Siswa;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

// Library
use DB;
use Illuminate\Database\Eloquent\SoftDeletes;

class SiswaMutasiModel extends Model
{
    // softdelete itu untuk fitur dari laravel. User hapus, data untuk user hilang tapi di tabel tidak hilang. cuma di hiden
    use HasFactory, SoftDeletes;

    // Nama tabel
    protected $table = 'siswa_mutasi';
    protected $guarded = ['id'];

    public function periode()
    {
        return $this->belongsTo(\App\Models\Master\PeriodeModel::class, 'idPPeriode', 'id');
    }

    public function kelaskode()
    {
        return $this->belongsTo(\App\Models\Perpus\KelasKodeModel::class, 'idPKKode', 'id');
    }

}
