<?php

namespace App\Models\Siswa;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

// Library
use DB;
use Illuminate\Database\Eloquent\SoftDeletes;

class SiswaModel extends Model
{
    // softdelete itu untuk fitur dari laravel. User hapus, data untuk user hilang tapi di tabel tidak hilang. cuma di hiden
    use HasFactory, SoftDeletes;

    // Nama tabel
    protected $table = 'siswa';
    protected $guarded = ['id'];

    public function kelaskode()
    {
        return $this->belongsTo(\App\Models\Perpus\KelasKodeModel::class, 'idPKKode', 'id');
    }

    public function agama()
    {
        return $this->belongsTo(\App\Models\Master\AgamaModel::class, 'idMAgama', 'id');
    }

    public function ortu()
    {
        return $this->belongsTo(\App\Models\Siswa\OrtuModel::class, 'idMOrtu', 'id');
    }

    public function tempat()
    {
        return $this->belongsTo(\App\Models\Master\TempatModel::class, 'idMTempat', 'id');
    }

    public function sekolah_wali()
    {
        return $this->belongsTo(\App\Models\Stakeholder\SekolahWaliModel::class, 'idPKKode', 'id');
    }

    public function konseling()
    {
        return $this->hasMany(\App\Models\Layanan\MutasiKonselingModel::class, 'idSiswa', 'id');
    }

    public function konselor()
    {
        return $this->belongsTo(\App\Models\Stakeholder\KonselorModel::class, 'idSKonselor', 'id');
    }

    public function pembinaan()
    {
        return $this->hasMany(\App\Models\Layanan\MutasiPembinaanModel::class, 'idSiswa', 'id');
    }

    public function sekolah()
    {
        return $this->belongsTo(Sekolah::class, 'idPSekolah');
    }
}
