<?php

namespace App\Models\Perpus;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

// Library
use DB;
use Illuminate\Database\Eloquent\SoftDeletes;

class KelasModel extends Model
{
    // softdelete itu untuk fitur dari laravel. User hapus, data untuk user hilang tapi di tabel tidak hilang. cuma di hiden
    use HasFactory, SoftDeletes;

    // Nama tabel
    protected $table = 'perpus_kelas';
    protected $guarded = ['id'];

    public function sekolah()
    {
        return $this->belongsTo(SekolahModel::class, 'idPSekolah', 'id');
    }

    public function jurusan()
    {
        return $this->belongsTo(JurusanModel::class, 'idPJurusan', 'id');
    }

    public function kelaskode()
    {
        return $this->hasMany(KelasKodeModel::class, 'idPKelas', 'id');
    }
}
