<?php

namespace App\Models\Log;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\SoftDeletes;
use Illuminate\Contracts\Session\Session;

// Library
use DB;
use Request;

class LogAcivityUserModel extends Model
{
    // softdelete itu untuk fitur dari laravel. User hapus, data untuk user hilang tapi di tabel tidak hilang. cuma di hiden
    use HasFactory, SoftDeletes;

    // Nama tabel
    protected $table = 'log_activity_user';
    protected $guarded = ['id'];

    public function insertLogActivity($subject = null)
    {
        $dataLogActivity = [
            'idUser'        => session()->get('users_id') ?? null,
            'subject'       => $subject ?? '-',
            'url'           => request()->fullUrl(),
            'method'        => request()->method(),
            'ip'            => request()->ip(),
            'agent'         => request()->header('user-agent')
        ];
        return DB::table('log_activity_user')->insert($dataLogActivity);
    }
}
