<?php

namespace App\Models\Layanan\Surat;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

// Library
use DB;
use Illuminate\Database\Eloquent\SoftDeletes;

class SUndangOrtuModel extends Model
{
    // softdelete itu untuk fitur dari laravel. User hapus, data untuk user hilang tapi di tabel tidak hilang. cuma di hiden
    use HasFactory, SoftDeletes;

    // Nama tabel
    protected $table = 'layanan_surat_undanganOrtu';
    protected $guarded = ['id'];

    public function periode()
    {
        return $this->belongsTo(\App\Models\Master\PeriodeModel::class, 'idPPeriode', 'id');
    }
    
    public function kelas()
    {
        return $this->belongsTo(\App\Models\Perpus\KelasModel::class, 'idPKelas', 'id');
    }

    public function kelasKode()
    {
        return $this->belongsTo(\App\Models\Perpus\KelasKodeModel::class, 'idPKKode', 'id');
    }

    public function kepsek()
    {
        return $this->belongsTo(\App\Models\Stakeholder\KepsekModel::class, 'idSKepsek', 'id');
    }

    public function siswa()
    {
        return $this->belongsTo(\App\Models\Siswa\SiswaModel::class, 'idSiswa', 'id');
    }

    public function ortu()
    {
        return $this->belongsTo(\App\Models\Siswa\OrtuModel::class, 'idOrtu', 'id');
    }

}
