<?php

namespace App\Models\Layanan;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

// Library
use DB;
use Illuminate\Database\Eloquent\SoftDeletes;

class MutasiPembinaanModel extends Model
{
    // softdelete itu untuk fitur dari laravel. User hapus, data untuk user hilang tapi di tabel tidak hilang. cuma di hiden
    use HasFactory, SoftDeletes;

    // Nama tabel
    protected $table = 'layanan_mutasi_pembinaan';
    protected $guarded = ['id'];

    public function siswa()
    {
        return $this->belongsTo(\App\Models\Siswa\SiswaModel::class, 'idSiswa', 'id');
    }

    public function konselor()
    {
        return $this->belongsTo(\App\Models\Stakeholder\KonselorModel::class, 'idSKonselor', 'id');
    }

    public function ortu()
    {
        return $this->belongsTo(\App\Models\Siswa\OrtuModel::class, 'idOrtu', 'id');
    }
}
