<?php

namespace App\Models\Layanan\Homevisit;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

// Library
use DB;
use Illuminate\Database\Eloquent\SoftDeletes;

class HomevisitTu extends Model
{
    // softdelete itu untuk fitur dari laravel. User hapus, data untuk user hilang tapi di tabel tidak hilang. cuma di hiden
    use HasFactory, SoftDeletes;

    // Nama tabel
    protected $table = 'layanan_homevisit_tu';
    protected $guarded = ['id'];

    public function periode()
    {
        return $this->belongsTo(\App\Models\Master\PeriodeModel::class, 'idPPeriode', 'id');
    }

    public function jabatan()
    {
        return $this->belongsTo(\App\Models\Master\JabatanModel::class, 'arrayJabatan', 'id');
    }

    public function sekolah()
    {
        return $this->belongsTo(\App\Models\Perpus\SekolahModel::class, 'idPSekolah', 'id');
    }

    public function kelas()
    {
        return $this->belongsTo(\App\Models\Perpus\KelasModel::class, 'idPKelas', 'id');
    }

    public function kelasKode()
    {
        return $this->belongsTo(\App\Models\Perpus\KelasKodeModel::class, 'idPKKode', 'id');
    }

    public function kepsek()
    {
        return $this->belongsTo(\App\Models\Stakeholder\KepsekModel::class, 'idSKepsek', 'id');
    }

    public function konselor()
    {
        return $this->belongsTo(\App\Models\Stakeholder\KonselorModel::class, 'idSKonselor', 'id');
    }

    public function guru()
    {
        return $this->belongsTo(\App\Models\Stakeholder\GuruModel::class, 'arrayIdSGuru', 'id');
    }

    public function siswa()
    {
        return $this->belongsTo(\App\Models\Siswa\SiswaModel::class, 'idSiswa', 'id');
    }

    public function ortu()
    {
        return $this->belongsTo(\App\Models\Siswa\OrtuModel::class, 'idOrtu', 'id');
    }

    public function homevisitkegiatan()
    {
        return $this->belongsTo(\App\Models\Layanan\Homevisit\HomevisitKegiatan::class, 'idLHKegiatan', 'id');
    }
}
