<?php

namespace App\Models\Layanan\FormIjin;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

// Library
use DB;
use Illuminate\Database\Eloquent\SoftDeletes;

class FormIjinKeluarMasalModel extends Model
{
    // softdelete itu untuk fitur dari laravel. User hapus, data untuk user hilang tapi di tabel tidak hilang. cuma di hiden
    use HasFactory, SoftDeletes;

    // Nama tabel
    protected $table = 'layanan_surat_ijinkeluarmasal';
    protected $guarded = ['id'];

    public function periode()
    {
        return $this->belongsTo(\App\Models\Master\PeriodeModel::class, 'idPPeriode', 'id');
    }
    
    public function kelas()
    {
        return $this->belongsTo(\App\Models\Perpus\KelasModel::class, 'idPKelas', 'id');
    }

    public function kelasKode()
    {
        return $this->belongsTo(\App\Models\Perpus\KelasKodeModel::class, 'idPKKode', 'id');
    }

    public function kepsek()
    {
        return $this->belongsTo(\App\Models\Stakeholder\KepsekModel::class, 'idSKepsek', 'id');
    }

    public function kurikulum()
    {
        return $this->belongsTo(\App\Models\Stakeholder\WakaKurikulumModel::class, 'idSKurikulum', 'id');
    }

    public function konselor()
    {
        return $this->belongsTo(\App\Models\Stakeholder\KonselorModel::class, 'idSKonselor', 'id');
    }

    public function piket()
    {
        return $this->belongsTo(\App\Models\Stakeholder\GuruPiketModel::class, 'idSPiket', 'id');
    }

    public function siswa()
    {
        return $this->belongsTo(\App\Models\Siswa\SiswaModel::class, 'idSiswa', 'id');
    }

    public function ortu()
    {
        return $this->belongsTo(\App\Models\Siswa\OrtuModel::class, 'idOrtu', 'id');
    }
}

