<?php

namespace App\Models\Import;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

// Library
use DB;
use Illuminate\Database\Eloquent\SoftDeletes; 

class ImportexcelGuruModel extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'importexcel_guru';
    protected $guarded = ['id'];


    public function sekolah()
    {
        return $this->belongsTo(\App\Models\Perpus\SekolahModel::class, 'idPSekolah', 'id');
    }

    public function periode()
    {
        return $this->belongsTo(\App\Models\Master\PeriodeModel::class, 'idPPeriode', 'id');
    }

    public function user()
    {
        return $this->belongsTo(\App\Models\User\UserModel::class, 'idUser', 'id');
    }
}
