<?php

namespace App\Models\Akademik;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

// Library
use DB;
use Illuminate\Database\Eloquent\SoftDeletes;

class AbsensiModel extends Model
{
    use HasFactory, SoftDeletes;

    protected $table = 'akademik_absensi';
    protected $guarded = ['id'];

    public function status(){
        return $this->belongsTo(\App\Models\Master\AkAbsensiStatusModel::class, 'idStatus', 'id');
    }

    public function kelasKode()
    {
        return $this->belongsTo(\App\Models\Perpus\KelasKodeModel::class, 'idPKKode', 'id');
    }
}
