<?php

namespace App\Http\Controllers\Api;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Models\Siswa\SiswaModel;
use App\Models\Stakeholder\SekolahWaliModel;
use App\Models\Stakeholder\GuruModel;
use App\Models\Perpus\KelasKodeModel;

class TabelStakeholderController extends Controller
{
    private $url        = 'admin/guru';

public function __construct()
    {
        createLogActivity();
        $this->mSiswa           = new SiswaModel();
        $this->mSekolahWali     = new SekolahWaliModel();
        $this->mGuru            = new GuruModel();
        $this->mPerpusKelasKode = new KelasKodeModel(); 
    }

    function getSekolahWali($idPKelas = null)
    {
        if(session()->get('role') == 1){
            $kelaskode = $this->mPerpusKelasKode->where('idPKelas', $idPKelas)->get();
        }else{
            $kelaskode = $this->mPerpusKelasKode->where('idPKelas', $idPKelas)->where('idPSekolah', session()->get('idPSekolah'))->get();
        }

        $i = 1;
        foreach ($kelaskode as $row)
        {

            $tbody      = [];
            $tbody[]    = $i++; 
            $tbody[]    = $row->kelas->nama.' '.$row->jurusan->nama.' '.$row->nama;

            if ($row->idSWali == 0) {
                $tbody[]    ='<span class="text-warning">Belum Diset</span>';
                $tbody[]    ='<span class="text-warning">Belum Diset</span>';
                $textWali   = "Pilih Wali Kelas";
            }else{
                $tbody[]    = $row->walikelas->guru->nip;
                $tbody[]    = $row->walikelas->guru->nama;
                $textWali   = "Ganti Wali Kelas";
            }

            $btnDetail = "<a href='".url($this->url."/wali-kelas/".$row['id'])."'><button type='button' class='btn btn-primary btn-sm' title='Detail Data'>Detail</button></a>";
            $btnEdit = "<button type='button' class='btn btn-primary btn-sm set-wali' title='Detail Data' data-bs-toggle='modal' data-bs-target='#modalPilihWali' data-id='".$row['id']."'>".$textWali."</button>";
            $btn = $btnDetail.' '.$btnEdit;
            
            $tbody[]    = $btn;

    
            $data[]     = $tbody;
        };
    
        if (count($kelaskode) > 0)
        {
            $response = [
                'data'      => $data,
            ];
            echo json_encode($response);
        }else{
            $response = [
                'data'      => '',
            ];
            echo json_encode($response);
        }
    }
}