<?php

namespace App\Http\Controllers\Api;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Models\Siswa\SiswaModel;
use App\Models\Perpus\KelasKodeModel;

class TabelSiswaController extends Controller
{
    private $url                    = 'admin/siswa';
    private $urlPeriode             = 'admin/tahun-ajaran';
    private $urlMutasiKonseling     = 'admin/layanan/konseling/konseling';
    private $urlMutasiPembinaan     = 'admin/layanan/konseling/bimbingan';

public function __construct()
    {
        createLogActivity();
        $this->mSiswa              = new SiswaModel();
        $this->mPerpusKelasKode              = new KelasKodeModel();
    }

    function getSekolahSiswa($idPKKode = null)
    {
        $where = [
            'idPKKode'      => $idPKKode,
            // 'idPPeriode'    => session()->get('idPPeriode'),
            'idMStatus'     => 1,
        ];

        if(session()->get('role') == 1){
            $siswa      = $this->mSiswa->where($where)->get();
        }else{
            
            $kelaskode = $this->mPerpusKelasKode->where('idPSekolah', session()->get('idPSekolah'))->where('id', $idPKKode)->get('id')->toArray();

            $whereSiswa = [
                'idPSekolah'        => session()->get('idPSekolah'),
                'idPPeriode'        => session()->get('idPPeriode'),
                'idPKKode'          => $kelaskode,
                'idMStatus'         => 1,
                'idPPkelas'         => 1,
                'idPPStatus'        => 1,
            ];
            $siswa      = $this->mSiswa->where($whereSiswa)->get();
        }

        $i = 1;
        foreach ($siswa as $row)
        {

            $btnDetail = "<a href='".url($this->url."/".$row->id)."'><button type='button' class='btn btn-primary btn-sm' title='Detail Data'>Detail</button></a>";
            $btnEdit = "<a href='".url($this->url."/".$row->id)."/edit"."'><button type='button' class='btn btn-primary btn-sm' title='Edit Data'>Edit</button></a>";
            $btn = $btnDetail.' '.$btnEdit;

            $tbody      = [];
            $tbody[]    = $i++; 
            $tbody[]    = $row->nisn;
            $tbody[]    = $row->nama;
            $tbody[]    = $btnDetail;

            $data[]     = $tbody;
        }

        // if ($siswa != null)
        if (count($siswa) > 0)
        {
            $response = [
                'data'      => $data,
            ];
            echo json_encode($response);
        }else{
            $response = [
                'data'      => '',
            ];
            echo json_encode($response);
        }
    }

    
    public function getPeriodeSiswa($idPKelas = null)
    {
        if(session()->get('role') == 1){
            $kelaskode = $this->mPerpusKelasKode->where('idPKelas', $idPKelas)->get();
        }else{
            $kelaskode = $this->mPerpusKelasKode->where('idPKelas', $idPKelas)->where('idPSekolah', session()->get('idPSekolah'))->get();
        }
        
        $i = 1;
        foreach ($kelaskode as $row)
        {

            $btnKelas = "<a href='".url($this->urlPeriode."/siswa/".$row->id)."'><button type='button' class='btn btn-primary btn-sm' title='Detail Data'>Detail Kelas</button></a>";
            $btnStatus = "<a href='".url($this->urlPeriode."/siswa/".$row->id)."'><button type='button' class='btn btn-primary btn-sm' title='Detail Data'>Detail Status</button></a>";
            $btn = $btnKelas.' '.$btnStatus;

            $btnDetail = "<a href='".url($this->urlPeriode."/siswa/".$row->id)."'><button type='button' class='btn btn-primary btn-sm' title='Detail Data'>Detail</button></a>";

            $tbody      = [];
            $tbody[]    = $i++; 
            $tbody[]    = $row->kelas->nama.' '.$row->kelas->jurusan->nama.' '.$row->nama;
            // $tbody[]    = count($row->periode_kelas); // kelas
            // $tbody[]    = count($row->periode_status); // status
            if(count($row->periode_kelas) > 0){
                $tbody[]    = count($row->periode_kelas); // kelas
                $tbody[]    = $btnDetail;
            }else{
                $tbody[]    = count($row->periode_kelas); // kelas
                $tbody[]    = '-';
            }

            $data[]     = $tbody;
        }

        // if ($siswa != null)
        if (count($kelaskode) > 0)
        {
            $response = [
                'data'      => $data,
            ];
            echo json_encode($response);
        }else{
            $response = [
                'data'      => '',
            ];
            echo json_encode($response);
        }
    }

    function getSiswaKonseling($idPKKode = null){

        $where = [
            'idPSekolah'        => session()->get('idPSekolah'),
            'idPPeriode'        => session()->get('idPPeriode'),
            'idPKKode'          => $idPKKode,
            'idSKonselor'       => session()->get('idSKonselor'),
            'idMStatus'         => 1,
            'idPPkelas'         => 1,
            'idPPStatus'        => 1,
        ];
        $siswa      = $this->mSiswa->where($where)->get();

        $i = 1;
        foreach ($siswa as $row)
        {

            $btnDetail = "<a href='".url($this->urlMutasiKonseling."/".$row->id)."'><button type='button' class='btn btn-primary btn-sm' title='Detail Data'>Detail</button></a>";
            $btnEdit = "<a href='".url($this->urlMutasiKonseling."/".$row->id)."/edit"."'><button type='button' class='btn btn-primary btn-sm' title='Detail Data'>Edit</button></a>";
            $btn = $btnDetail.' '.$btnEdit;

            $tbody      = [];
            $tbody[]    = $i++; 
            $tbody[]    = $row->nisn;
            $tbody[]    = $row->nama;
            $tbody[]    = count($row->konseling);
            $tbody[]    = $btnDetail;

            $data[]     = $tbody;
        }

        // if ($siswa != null)
        if (count($siswa) > 0)
        {
            $response = [
                'data'      => $data,
            ];
            echo json_encode($response);
        }else{
            $response = [
                'data'      => '',
            ];
            echo json_encode($response);
        }
    }

    function getSiswaPembinaan($idPKKode = null)
    {
        $where = [
            'idPSekolah'        => session()->get('idPSekolah'),
            'idPPeriode'        => session()->get('idPPeriode'),
            'idPKKode'          => $idPKKode,
            'idSKonselor'       => session()->get('idSKonselor'),
            'idMStatus'         => 1,
            'idPPkelas'         => 1,
            'idPPStatus'        => 1,
        ];
        $siswa      = $this->mSiswa->where($where)->get();
        // $siswa      = $this->mSiswa->get(['idPKKode', 'idMStatus', 'idSKonselor', 'nama']);
        // echo json_encode($siswa); die;

        $i = 1;
        foreach ($siswa as $row)
        {

            $btnDetail = "<a href='".url($this->urlMutasiPembinaan."/".$row->id)."'><button type='button' class='btn btn-primary btn-sm' title='Detail Data'>Detail</button></a>";
            $btnEdit = "<a href='".url($this->urlMutasiPembinaan."/".$row->id)."/edit"."'><button type='button' class='btn btn-primary btn-sm' title='Detail Data'>Edit</button></a>";
            $btn = $btnDetail.' '.$btnEdit;

            $tbody      = [];
            $tbody[]    = $i++; 
            $tbody[]    = $row->nisn;
            $tbody[]    = $row->nama;
            $tbody[]    = count($row->pembinaan);
            $tbody[]    = $btnDetail;

            $data[]     = $tbody;
        }

        // if ($siswa != null)
        if (count($siswa) > 0)
        {
            $response = [
                'data'      => $data,
            ];
            echo json_encode($response);
        }else{
            $response = [
                'data'      => '',
            ];
            echo json_encode($response);
        }
    }
}