<?php

namespace App\Http\Controllers\Api;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use App\Models\Event\EventModel;

class EventController extends Controller
{
    public function __construct()
    {
        createLogActivity();
        $this->mEvent       = New EventModel();
    }

    public function getAllEvent()
    {
        $events = $this->mEvent->get(['id', 'image', 'title', 'status', 'date', 'location', 'description']);

        $transformedEvents = $events->map(function ($event) {
            return [
                'id'            => $event->event_id,
                'image'         => $event->image,
                'title'         => $event->title,
                // 'status'        => $event->status,
                'date'          => $event->title,
                'location'      => $event->title,
                'description'   => $event->title,
            ];
        });

        return response()->json($transformedEvents);
    }
}