<?php

namespace App\Http\Controllers\Api;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Models\Master\ProvinsiModel;
use App\Models\Master\DaerahModel;

use App\Models\Perpus\SekolahModel;
use App\Models\Perpus\JurusanModel;
use App\Models\Perpus\KelasModel;
use App\Models\Perpus\KelasKodeModel;
// use App\Models\MGuruPiketModel;
// use App\Models\MGuruModel;

class DaerahController extends Controller
{
public function __construct()
    {
        createLogActivity();
        $this->mProvinsi                = new ProvinsiModel();
        $this->mDaerah                  = new DaerahModel();

        $this->mPerpusSekolah         = new SekolahModel();
        $this->mPerpusJurusan         = new JurusanModel();
        $this->mPerpusKelas           = new KelasModel();
        $this->mPerpusKelasKode       = new KelasKodeModel();
        // $this->mGuruPiket             = new MGuruPiketModel();
        // $this->mGuru                  = new MGuruModel();
        
    }

    public function getAllProvinsi()
    {
        $provinsi = $this->mProvinsi->get();
        $data = [
            'error_code'    => 0,
            'data'          => $provinsi,
        ];
        echo json_encode($data);
    }

    public function getProvinsiDaerah($idMprovinsi = null)
    {
        $daerah = $this->mDaerah->where('idMprovinsi', $idMprovinsi)->get();

        $data = [
            'error_code'    => 0,
            'data'          => $daerah,
        ];
        echo json_encode($data);
    }

    public function getDaerahSekolah($idMDaerah = null)
    {
        if(session()->get('role') == 1){
            $perpus_sekolah = $this->mPerpusSekolah->where('idMDaerah', $idMDaerah)->get();
        }else{
            $perpus_sekolah = [];
        }

        $data = [
            'error_code'    => 0,
            'data'          => $perpus_sekolah,
        ];
        echo json_encode($data);
    }

    public function getJurusanSekolah($idPSekolah = null)
    {
        if(session()->get('role') == 1){
            $jurusan = $this->mPerpusJurusan->where('idPSekolah', $idPSekolah)->get();
        }else{
            $jurusan = $this->mPerpusJurusan->where('idPSekolah', session()->get('idPSekolah'))->get();
        }
        
        $data = [
            'error_code'    => 0,
            'data'          => $jurusan,
        ];
        echo json_encode($data);
    }

    public function getAngkatanSekolah($idPJurusan = null)
    {
        if(session()->get('role') == 1){
            $kelas = $this->mPerpusKelas->where('idPJurusan', $idPJurusan)->get();
        }else{
            $kelas = $this->mPerpusKelas->where('idPJurusan', $idPJurusan)->where('idPSekolah', session()->get('idPSekolah'))->get();
        }

        $data = [
            'error_code'    => 0,
            'data'          => $kelas,
        ];
        echo json_encode($data);
    }

    public function getKelasSekolah($idAngkatan = null)
    {
        if(session()->get('role') == 1){
            $kelaskode = $this->mPerpusKelasKode->where('idPKelas', $idAngkatan)->get();
        }else{
            $kelaskode = $this->mPerpusKelasKode->where('idPKelas', $idAngkatan)->where('idPSekolah', session()->get('idPSekolah'))->get();
        }

        $data = [
            'error_code'    => 0,
            'data'          => $kelaskode,
        ];
        echo json_encode($data);
    }

    
    // public function getcKelasSekolah($idAngkatan = null)
    // {
    //     $kelaskode = $this->mPerpusKelasKode->where('idPKelas', $idAngkatan)->get();

    //     foreach($kelaskode as $kk){

    //         $dataAnyar[] =[
    //             'id'            => $kk['id'],
    //             'idc'           => enc($kk['id']),
    //             'idPSekolah'    => $kk['idPSekolah'],
    //             'idPJurusan'    => $kk['idPJurusan'],
    //             'idPKelas'      => $kk['idPKelas'],
    //             'nama'          => $kk['nama'],
    //         ];
    //     }

    //     $data = [
    //         'error_code'    => 0,
    //         'data'          => $dataAnyar,
    //     ];
    //     echo json_encode($data);
    // }

    public function getcKelasSekolah($idAngkatan = null)
    {
        if(session()->get('role') == 1){
            $kelaskode = $this->mPerpusKelasKode->where('idPKelas', $idAngkatan)->get()->toArray();
        }else{
            $kelaskode = $this->mPerpusKelasKode->where('idPKelas', $idAngkatan)->where('idPSekolah', session()->get('idPSekolah'))->get()->toArray();
        }

        $dataAnyar = array_map(function($kk) {
            return [
                'idc'            => enc($kk['id']),
                'idPSekolah'    => $kk['idPSekolah'],
                'idPJurusan'    => $kk['idPJurusan'],
                'idPKelas'      => $kk['idPKelas'],
                'nama'          => $kk['nama'],
            ];
        }, $kelaskode);

        $data = [
            'error_code'    => 0,
            'data'          => $dataAnyar,
        ];
        echo json_encode($data);
    }

    public function getKelasKomplit($idPSekolah = null)
    {
        if(session()->get('role') == 1){
            $kelas = $this->mPerpusKelasKode->with('kelas')->with('jurusan')->where('idPSekolah', $idPSekolah)->get()->toArray();
        }else{
            $kelas = $this->mPerpusKelasKode->with('kelas')->with('jurusan')->where('idPSekolah', session()->get('idPSekolah'))->get()->toArray();
        }
        // echo json_encode($kelas); die;

        $dataAnyar = array_map(function($kk) {
            return [
                'id'            => $kk['id'],
                'nama'          => $kk['kelas']['nama'].' '.$kk['jurusan']['nama'].' '.$kk['nama'],
            ];
        }, $kelas);
        
        $data = [
            'error_code'    => 0,
            'data'          => $dataAnyar,
        ];
        echo json_encode($data);
    }
    
    public function getAngkatanKomplit($idPSekolah = null)
    {
        if(session()->get('role') == 1){
            $kelas = $this->mPerpusKelas->with('jurusan')->where('idPSekolah', $idPSekolah)->get()->toArray();
        }else{
            $kelas = $this->mPerpusKelas->with('jurusan')->where('idPSekolah', session()->get('idPSekolah'))->get()->toArray();
        }
        // echo json_encode($kelas); die;

        $dataAnyar = array_map(function($kk) {
            return [
                'id'            => $kk['id'],
                'nama'          => $kk['nama'].' '.$kk['jurusan']['nama'],
            ];
        }, $kelas);
        
        $data = [
            'error_code'    => 0,
            'data'          => $dataAnyar,
        ];
        echo json_encode($data);
    }

}