<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\Master\JenisSekolahModel;
use App\Models\Master\JenisOwnerModel;


class ChartJenisSekolahController extends Controller
{
    public function __construct()
    {
        createLogActivity();
        $this->mJSekolah       = new JenisSekolahModel();
        $this->mJOwner       = new JenisOwnerModel();
    }

    public function getChartJmlSekolah()
    {
        $jenisSekolahCount = $this->mJSekolah->withCount('sekolah')
            ->get()
            ->map(function ($jenis) {
                return [
                    'jenis' => $jenis->nama, // Asumsi kolom 'nama' di tabel jenis_sekolah
                    'jumlah' => $jenis->sekolah_count
                ];
            });
        
        // echo json_encode($jenisSekolahCount);
        return response()->json($jenisSekolahCount);
    }

    public function getChartJmlSiswa()
    {
        $data = $this->mJSekolah->with('sekolah.siswa')
                ->get()
                ->map(function ($jenis) {
                    $jumlahSiswa = $jenis->sekolah->sum(function ($sekolah) {
                        return $sekolah->siswa->count();
                    });

                    return ['jenis' => $jenis->nama, 'jumlah' => $jumlahSiswa];
                });

        return response()->json($data);
    }
}