<?php

//redirect ke folder
namespace App\Http\Controllers\Admin\Stakeholder;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use DB;
use App\Models\Stakeholder\WakaKurikulumModel;
use App\Models\Stakeholder\GuruModel;

class WakaKurikulumController extends Controller
{
    private $views      = 'admin/stakeholder/waka_kurikulum';
    private $url        = 'admin/guru/waka-kurikulum';
    private $title      = 'Halaman Waka Kurikulum';

public function __construct()
    {
        createLogActivity();
        $this->mWakaKurikulum     = new WakaKurikulumModel();
        $this->mGuru              = new GuruModel();
    }

    public function index()
    {
        $where = [
            'status' => 1,
            'idPSekolah'=> session()->get('idPSekolah'),
        ];
        $wakaKurikulum = $this->mWakaKurikulum->where($where)->first();
        if(isset($wakaKurikulum)){
            $guru = $this->mGuru->where('id', $wakaKurikulum['idSGuru'])->get(); // tampilkan data guru sebagai kepsek
        }else{
            $guru = null;
        }

        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Waka Kurikulum',
            'guru'         => $guru,
        ];

        return view($this->views . "/index", $data);
    }

    public function create()
    {
        $where = [
            'status' => 1,
            'idPSekolah'=> session()->get('idPSekolah'),
        ];
        $wakaKurikulum = $this->mWakaKurikulum->where($where)->first();

        if(isset($wakaKurikulum)){

            $guru = $this->mGuru->where($where)->whereNot('id', $wakaKurikulum['idSGuru'])->get();
        }else{
            $guru = $this->mGuru->where($where)->get();
        }

        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Tambah Data Waka Kurikulum',
            'guru'     => $guru,
        ];

        return view($this->views . "/create", $data);
    }

    public function store(Request $request)
    {
        $where = [
            'status' => 1,
            'idPSekolah'=> session()->get('idPSekolah'),
        ];
        $dataStatus = [
            'status'    => 0 // update semua statusya jadi 0
        ];
        // cari yang statusnya 1, terus semua diupdate jadi 0
        $this->mWakaKurikulum->where($where)->update($dataStatus);

        // cek ada guru yg sama di tabel kepsek tidak
        $wakaKesiswaan = $this->mWakaKurikulum->where('idSGuru', $request->idSGuru)->first();
        if (isset($wakaKesiswaan)){ // kalo ada, update status. bukan tambah data guru di tabel kepsek
            $dataStatus = [
                'status'    => 1 // update status guru tsb di tabel kepsek jadi 1
            ];
            $this->mWakaKurikulum->where('idSGuru', $request->idSGuru)->update($dataStatus);
        }else{ // kalo data guru tsb di tabel kepsek tidak ada, baru tambah baru. jadi gag ada nama yg sama di tabel kepsek
            // tambah data sekaligus aktifkan jadi status 1
            $dataWakaKesiswaan = [
                'idPSekolah'    => session()->get('idPSekolah'),
                'idSGuru'      => $request->idSGuru,
                'status'        => 1
            ];
            $this->mWakaKurikulum->create($dataWakaKesiswaan);
        }

        // dd($kepsek);
        return redirect("$this->url")->with('sukses', 'Waka Kurikulum Berhasil di Perbarui');
    }

    public function show($id)
    {
        // Get Data
    }

    public function edit($id)
    {
        // Get Data
        // $siswa     = $this->mSiswa->where('id', $id)->first();
        // $kelaskode = $this->mPerpusKelasKode->get();
        // $agama     = $this->mAgama->get();

        // $data = [
        //     'title'         => $this->title,
        //     'url'           => $this->url,
        //     'page'          => 'Edit Data Kepala Sekolah',
        //     'id'            => $id,
        //     'siswa'         => $siswa,
        //     'kelaskode'     => $kelaskode,
        //     'agama'         => $agama,
        // ];
        // return view($this->views . "/edit", $data);
    }

    public function update(Request $request, $id)
    {
        // Validasi
        // $request->validate([
        //     'id'            => 'required',
        //     'idPKKode'      => 'required',
        //     'idMAgama'      => 'required',
        //     'nisn'          => 'required',
        //     'nama'          => 'required',
        //     'lahir_tanggal' => 'required',
        //     'lahir_tempat'  => 'required',
        // ]);
        
        // $dataSiswa = [
        //     'idPKKode'      => $request->idPKKode,
        //     'idMAgama'      => $request->idMAgama,
        //     'nisn'          => $request->nisn,
        //     'nama'          => $request->nama,
        //     'lahir_tanggal' => $request->lahir_tanggal,
        //     'lahir_tempat'  => $request->lahir_tempat,
        // ];
        // $this->mSiswa->where('id', $request->id)->update($dataSiswa);

        // // Response
        // return redirect("$this->url")->with('sukses', 'Data Kepala Sekolah berhasil di edit');
    }

    public function destroy($id)
    {
        //
    }
}
