<?php

namespace App\Http\Controllers\Admin\Stakeholder;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Models\Perpus\SekolahModel;
use App\Models\Perpus\JurusanModel;
use App\Models\Perpus\KelasModel;
use App\Models\Perpus\KelasKodeModel;
use App\Models\Stakeholder\SekolahWaliModel;
use App\Models\Stakeholder\GuruModel;
use App\Models\Master\PeriodeModel;
use App\Models\Siswa\SiswaModel;

class SekolahWaliController extends Controller
{
    private $views      = 'admin/stakeholder/sekolahwali';
    private $url        = 'admin/guru/wali-kelas';
    private $title      = 'Halaman Wali Kelas';

public function __construct()
    {
        createLogActivity();
        $this->mPerpusSekolah       = new SekolahModel();
        $this->mPerpusJurusan       = new JurusanModel();
        $this->mPerpusKelas         = new KelasModel();
        $this->mPerpusKelasKode     = new KelasKodeModel();
        $this->mSekolahWali         = new SekolahWaliModel();
        $this->mGuru                = new GuruModel();
        $this->mPerpusPeriode       = new PeriodeModel();
        $this->mSiswa               = new SiswaModel();
    }

    public function index()
    {
        
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Wali Kelas',
        ];

        return view($this->views . "/index", $data);
    }

    public function show($id)
    {
        $perpus_kelasKode   = $this->mPerpusKelasKode->where('id', $id)->first();
       
        $data = [
            'title'                 => $this->title,
            'url'                   => $this->url,
            'page'                  => 'Detail Data Wali Kelas',
            'id'                    => $id,
            'perpus_kelasKode'      => $perpus_kelasKode,
            
        ];
        return view($this->views . "/show", $data);
    }

    public function edit($id)
    {
        $kelaskode = $this->mPerpusKelasKode->where('id', $id)->first(); // untuk ambil id kelas

        // dapatkan semua data wali, status=1 dan sekolah itu
        $where = [
            'idPSekolah'    => session()->get('idPSekolah'),
            'idPPeriode'    => session()->get('idPPeriode'),
            'status'        => 1,
        ];
        $sekolah_wali = $this->mSekolahWali->where($where)->pluck('idSGuru')->toArray();

        // guru tidak jadi wali
        $guru = $this->mGuru->where('idPSekolah', session()->get('idPSekolah'))->whereNotIn('id',$sekolah_wali)->get();

        $data = [
            'title'             => $this->title,
            'url'               => $this->url,
            'page'              => 'Edit Data Wali Kelas',
            'id'                => $id,
            'guru'              => $guru,
            'kelaskode'         => $kelaskode
        ];
        return view($this->views . "/edit", $data);
    }

    public function getNonWali()
    {
        // dapatkan semua data wali, status=1 dan sekolah itu
        $where = [
            'idPSekolah'    => session()->get('idPSekolah'),
            'idPPeriode'    => session()->get('idPPeriode'),
            'status'        => 1,
        ];
        $sekolah_wali = $this->mSekolahWali->where($where)->pluck('idSGuru')->toArray();

        // guru tidak jadi wali
        $guru = $this->mGuru->where('idPSekolah', session()->get('idPSekolah'))->whereNotIn('id',$sekolah_wali)->get();

        if (count($guru) > 0)
        {
            $response = [
                'error_code'    => 0,
                'data'          => $guru,
            ];
            echo json_encode($response);
        }else{
            $response = [
                'error_code'    => 404,
                'data'          => '',
            ];
            echo json_encode($response);
        }
    }

    public function update(Request $request, $id)
    {
        // Validasi
        $request->validate([
            'idSGuru'       => 'required',
        ]);

        $kelaskode = $this->mPerpusKelasKode->where('id', $id)->first(); // untuk ambil id kelas

        if($kelaskode->idSWali == 0){
 
            // ============ insert baru wali kelas
            $dataSekolahWali = [
                'idPSekolah'    => session()->get('idPSekolah'),
                'idPPeriode'    => session()->get('idPPeriode'),
                'idPKKode'      => $id,
                'idSGuru'       => $request->idSGuru,
                'status'        => 1,
            ];
            $wali = $this->mSekolahWali->create($dataSekolahWali);

            $this->mPerpusKelasKode->where('id', $id)->update(['idSWali' => $wali->id]);

        }else{
            // ============ update ganti wali kelas

            // update wali kelas lama status 0 kan, biar history gag ilang
            $whereWali = [
                'idPSekolah'    => session()->get('idPSekolah'),
                'idPPeriode'    => session()->get('idPPeriode'),
                'idPKKode'      => $id,
            ];
            $this->mSekolahWali->where($whereWali)->update(['status'=>0]);

            // insert wali kelas baru status 1
            $whereSekolahWali = [
                'idPSekolah'    => session()->get('idPSekolah'),
                'idPPeriode'    => session()->get('idPPeriode'),
                'idPKKode'      => $id,
                'idSGuru'       => $request->idSGuru,
                'status'        => 1,
            ];
            $sekolahWali = $this->mSekolahWali->create($whereSekolahWali);

            // set di kelas
            $this->mPerpusKelasKode->where('id', $id)->update(['idSWali' => $sekolahWali->id]);
        }

        return redirect("$this->url")->with('sukses', 'Data Wali berhasil di edit');
    }

    public function destroy($id)
    {
        $whereWali = [
            'idPKKode'      => $id,
            'idPPeriode'    => session()->get('idPPeriode')
        ];
        $sekolah_wali = $this->mSekolahWali->where($whereWali)->first();

        if (isset($sekolah_wali)) {

            $dataKel = [
                'idSWali' => 0
            ];
            // echo json_encode($dataKel); die;
            $this->mPerpusKelasKode->where('id', $id)->update($dataKel);
            $this->mSekolahWali->destroy($sekolah_wali['id']);
            return redirect("$this->url")->with('sukses', 'Data Wali berhasil di hapus');
        }else{
            return redirect("$this->url")->with('gagal', 'Data Wali gagal di hapus');

        }
    }
}
