<?php

//redirect ke folder
namespace App\Http\Controllers\Admin\Stakeholder;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use DB;
use App\Models\Stakeholder\GuruModel;
use App\Models\Stakeholder\GuruPiketModel;

class GuruPiketController extends Controller
{
    private $views      = 'admin/stakeholder/gurupiket';
    private $url        = 'admin/guru/guru-piket';
    private $title      = 'Halaman Guru Piket';

public function __construct()
    {
        createLogActivity();
        $this->mGuruPiket     = new GuruPiketModel();
        $this->mGuru         = new GuruModel();
    }

    public function index()
    {
        $guru_piket = $this->mGuruPiket->where('idPSekolah', session()->get('idPSekolah'))->get();
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Guru Piket Aktif',
            'guru_piket'    => $guru_piket,
        ];

        return view($this->views . "/index", $data);
    }

    public function create()
    {
        $guru_piket = $this->mGuruPiket->where('idPSekolah', session()->get('idPSekolah'))->pluck('idSGuru')->toArray();
        $guru = $this->mGuru->whereNotIn('id', $guru_piket)
                    ->where('idPSekolah', session()->get('idPSekolah'))->get();

        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Tambah Data Guru Piket',
            'guru'          => $guru,
        ];
        return view($this->views . "/create", $data);
    }

    public function store(Request $request)
    {
        $dataGuruPiket = [
            'idPSekolah'=> session()->get('idPSekolah'),
            'idSGuru'      => $request->idSGuru,
            'status'      => 1,
        ];
        $this->mGuruPiket->create($dataGuruPiket);
        return redirect("$this->url")->with('sukses', 'Data Guru Piket berhasil di tambahkan');
    }

    public function show($id)
    {
        // 
    }

    public function edit($id)
    {
        $gurupiket = $this->mGuruPiket->where('id', $id)->first();
        
        if($gurupiket['status'] == 1){
            $data =  [
                'status' => 0
            ];
            $this->mGuruPiket->where('id', $id)->update($data);
        }elseif($gurupiket['status'] == 0){
            $data =  [
                'status' => 1
            ];
            $this->mGuruPiket->where('id', $id)->update($data);
        }
        return redirect("$this->url")->with('sukses', 'Data Guru Piket berhasil di ganti');
    }

    public function update(Request $request, $id)
    {
        // 
    }

    public function destroy($id)
    {
        //
    }
}
