<?php

namespace App\Http\Controllers\Admin\Stakeholder;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;

use App\Models\Master\MapelGuruModel;

use App\Models\Perpus\SekolahModel;
use App\Models\Perpus\JurusanModel;
use App\Models\Perpus\KelasModel;
use App\Models\Perpus\KelasKodeModel;

use App\Models\Stakeholder\GuruModel;
use App\Models\Stakeholder\SekolahWaliModel;
use App\Models\Stakeholder\GuruPiketModel;

use PhpOffice\PhpWord\TemplateProcessor;

class GuruController extends Controller
{
    private $views      = 'admin/stakeholder/guru';
    private $url        = 'admin/guru';
    private $title      = 'Halaman Data Guru';

public function __construct()
    {
        createLogActivity();
        // Di isi Construct
        $this->mMapelGuru               = New MapelGuruModel();
        $this->mPerpusSekolah           = new SekolahModel();
        $this->mPerpusJurusan           = new JurusanModel();
        $this->mPerpusKelas             = new KelasModel();
        $this->mPerpusKelasKode         = new KelasKodeModel();
        $this->mGuru                    = new GuruModel();
        $this->mSekolahWali             = new SekolahWaliModel();
        $this->mGuruPiket               = new GuruPiketModel();
    }
    
    public function index()
    {
        $guru = $this->mGuru->where('idPSekolah', session()->get('idPSekolah'))->get();

        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Guru',
            'guru'          => $guru,
        ];

        return view($this->views . "/index", $data);
    }

    public function create()
    {
        $mapel = $this->mMapelGuru->get();

        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Tambah Data Guru',
            'mapel'         => $mapel
        ];

        return view($this->views . "/create", $data);
    }

    public function store(Request $request)
    {
        $request->validate([
            'nip'       => 'required|numeric',
            'nama'      => 'required',
            'idMapel'   => 'required'
        ]);

        $cekGuru = $this->mGuru->where('nip', $request->nip)->first();

        if(isset($cekGuru)){
            return redirect("$this->url")->with('gagal', 'NIP sudah terdaftar, mohon kontak dengan admin SIBILING');
        }

        $dataGuru = [
            'idPSekolah'    => session()->get('idPSekolah'),
            'nip'           => $request->nip,
            'nama'          => $request->nama,
            'telp'          => $request->telp,
            'idMapel'       => $request->idMapel,
            'status'        => 1,
        ];
        $dataSGuru = $this->mGuru->create($dataGuru);

        // $this->mGuru->create($dataGuru);
        return redirect("$this->url")->with('sukses', 'Data Guru berhasil di tambahkan');
    }

    public function show($id)
    {
        // Get Data
        $guru               = $this->mGuru->where('id', $id)->first();

        if (!$guru) {
            return redirect()->back()->with('gagal', 'Data Guru tidak ditemukan atau sudah dihapus.');
        }

        $data = [
            'title'                 => $this->title,
            'url'                   => $this->url,
            'page'                  => 'Detail Data Guru',
            'guru'                  => $guru,
        ];
        return view($this->views . "/show", $data);
    }

    public function edit($id)
    {
        $guru = $this->mGuru->where('id', $id)->first();
        $mapel = $this->mMapelGuru->get();

        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Edit Data Guru',
            'guru'          => $guru,
            'mapel'         => $mapel
        ];

        return view($this->views . "/edit", $data);

    }

    public function update(Request $request, $id)
    {
        $dataGuru = [
            'nama'        => $request->nama,
            'nip'         => $request->nip,
            'idMapel'     => $request->idMapel,
        ];
        $this->mGuru->where('id', $id)->update($dataGuru);
        return redirect("$this->url")->with('sukses', 'Data Guru berhasil di edit');
    }


    public function updateStatus($id = null)
    {
        if($id == null){
            return redirect("$this->url")->with('gagal', 'Data Guru tidak ditemukan');
        }

        $guru = $this->mGuru->where('id', $id)->first();

        if(!isset($guru)){
            return redirect("$this->url")->with('gagal', 'Data Guru tidak ditemukan');
        }

        if($guru->status == 0){
            $this->mGuru->where('id', $id)->update(['status' => 1]);
            return redirect("$this->url")->with('sukses', 'Data Guru berhasil di Aktifkan');
        }
        else if($guru->status == 1){
            $this->mGuru->where('id', $id)->update(['status' => 0]);
            return redirect("$this->url")->with('sukses', 'Data Guru berhasil di Non Aktifkan');
        }else{
            return redirect("$this->url")->with('gagal', 'Data Guru Gagal di Update');
        }

    }

    public function delete($id = null)
    {
        if($id == null){
            return redirect("$this->url")->with('gagal', 'Data Guru tidak ditemukan');
        }

        $guru = $this->mGuru->where('id', $id)->first();

        if(!isset($guru)){
            return redirect("$this->url")->with('gagal', 'Data Guru tidak ditemukan');
        }

        $this->mGuru->where('id', $id)->delete();
        return redirect("$this->url")->with('sukses', 'Data Guru berhasil di hapus');
    }
}
