<?php

//redirect ke folder
namespace App\Http\Controllers\Admin\Perpus;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Models\User\UserModel;
use App\Models\User\UserUsulanModel;
use App\Models\Perpus\SekolahModel;

use DB;
use Illuminate\Support\Facades\Hash;
use Str;
use File;

class SekolahRequestController extends Controller
{
    private $views      = 'admin/perpus/sekolah_usulan';
    private $url        = 'admin/master/sekolah-request';
    private $title      = 'Halaman Usulan Admin Sekolah';

public function __construct()
    {
        createLogActivity();
        $this->mUser            = new UserModel();
        $this->mUserUsulan      = new UserUsulanModel();
        $this->mPerpusSekolah   = new SekolahModel();
    
    }

    public function index()
    {
        $usulan = $this->mUserUsulan->get();

        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Sekolah',
            'usulan'        => $usulan,
        ];

        return view($this->views . "/index", $data);
    }

    public function show($id)
    {
        $usulan = $this->mUserUsulan->where('id', $id)->first();

        $data = [
            'title'             => $this->title,
            'url'               => $this->url,
            'page'              => 'Detail Data Sekolah',
            'usulan'            => $usulan,
        ];
        return view($this->views . "/show", $data);
    }

    public function accept(Request $request, $id)
    {
        $usulan = $this->mUserUsulan->where('id', $id)->first();

        if($usulan->status != 0){
            return redirect("$this->url")->with('gagal', 'Request sudah pernah di terima / tolak');
        }

        $user = $this->mUser->where('username', $usulan->npsn)->first();
        $sekolah = $this->mPerpusSekolah->where('npsn', $usulan->npsn)->first();

        if(isset($user) || isset($sekolah)){
            $this->mUserUsulan->where('id', $id)->update(['status' => 2]);

            return redirect("$this->url")->with('gagal', 'Sekolah sudah terdaftar, otomatis ditolak');
        }

        // draft
        $dataPerpusSekolah = [
            'idMDaerah'     => $usulan->idMDaerah,
            'idPPeriode'    => $usulan->idPPeriode,
            'nama'          => $usulan->nama,
            'alamat'        => $usulan->alamat ?? '',
            'logo'          => $fileName ?? '',
            'logo_gambar'   => $fileNama ?? '',
            'telp'          => $usulan->nomor ?? '',
            'web'           => $usulan->web ?? '',
            'email'         => $usulan->email ?? '',
            'npsn'          => $usulan->npsn,
        ];
        $sekolah = $this->mPerpusSekolah->create($dataPerpusSekolah);

        // draft
        $dataUser = [
            'username'          => $usulan->npsn,
            'password'          => Hash::make('bk-peduli'),
            'sandi'             => 'bk-peduli',
            'status'            => 1,
            'idPSekolah'        => $sekolah->id,
            'role'              => 2,
            'idPPeriode'        => $usulan->idPPeriode,
        ];
        $this->mUser->create($dataUser);

        $this->mUserUsulan->where('id', $id)->update(['status' => 1]);

        $message = "Akun Anda Telah Aktif!

        Hai ".$sekolah->nama.",
        
        Selamat! Akun Anda dengan Sistem Informasi Bimbingan dan Konseling (SIBILING) telah berhasil diaktifkan.
        
        Anda kini dapat login sebagai role Admin Sekolah dan mulai menggunakan layanan kami. Berikut adalah informasi login Anda:
        
        Username: ".$sekolah->npsn."
        Password: bk-peduli
        Untuk login, silakan kunjungi halaman berikut: https://sibiling.dinus.ac.id
        
        Jika Anda mengalami kesulitan atau memiliki pertanyaan, jangan ragu untuk menghubungi tim dukungan kami di WhatsApp 081225296005
        
        Terima kasih telah memilih Sibiling. Kami sangat senang Anda bergabung dengan kami dan berharap dapat memberikan pengalaman terbaik untuk Anda.
        
        Salam hangat,
        
        Tim Pengembang Sistem Informasi Bimbingan dan Konseling
        Jl. Imam Bonjol No. 207, Kota Semarang
        081225296005";

        try {
            kirimWhatsapp($sekolah->telp, $message);
            return redirect("$this->url")->with('sukses', 'Usulan diterima, Data sekolah berhasil di input');
        
        }catch (\Exception $e) {
            // DB::rollback();
            // error message
            return redirect("$this->url")->with('gagal', 'Terjadi error: '. $e->getMessage());
        }
    }

    public function decline(Request $request, $id)
    {
        $usulan = $this->mUserUsulan->where('id', $id)->first();

        if($usulan->status != 0){
            return redirect("$this->url")->with('gagal', 'Request sudah pernah di terima / tolak');
        }

        $user = $this->mUser->where('username', $usulan->npsn)->first();
        $sekolah = $this->mPerpusSekolah->where('npsn', $usulan->npsn)->first();

        if(isset($user) || isset($sekolah)){
            $this->mUserUsulan->where('id', $id)->update(['status' => 2]);

            return redirect("$this->url")->with('gagal', 'Sekolah sudah terdaftar, otomatis ditolak');
        }

        $this->mUserUsulan->where('id', $id)->update(['status' => 2]);
        // Response
        return redirect("$this->url")->with('gagal', 'Usulan ditolak');
    }
}
