<?php

//redirect ke folder
namespace App\Http\Controllers\Admin\Perpus;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Models\Perpus\SekolahModel;
use App\Models\Perpus\JurusanModel;
use App\Models\Perpus\KelasModel;
use App\Models\Perpus\KelasKodeModel;

class JurusanController extends Controller
{
    private $views      = 'admin/perpus/jurusan';
    private $url        = 'admin/master/sekolah/jurusan';
    private $url2        = 'admin/master/sekolah/tingkat';
    private $title      = 'Halaman Data Jurusan';

public function __construct()
    {
        createLogActivity();
        // Di isi Construct. Biasanya saya isi untuk Model

        $this->mPerpusSekolah           = new SekolahModel();
        $this->mPerpusJurusan           = new JurusanModel();
        $this->mPerpusKelas             = new KelasModel();
        $this->mPerpusKelasKode         = new KelasKodeModel();
    
    }

    public function index()
    {
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Jurusan',
        ];

        return view($this->views . "/index", $data);
    }

    public function create()
    {
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Tambah Data Jurusan',
        ];

        return view($this->views . "/create", $data);
    }

    public function store(Request $request)
    {

        $dataPerpusJurusan = [
            'idPSekolah'      => $request->idPSekolah,
            'nama'            => $request->nama,
        ];
        $this->mPerpusJurusan->create($dataPerpusJurusan);

        return redirect("$this->url")->with('sukses', 'Data Jurusan berhasil di tambahkan');
    }

    public function show($id)
    {
        if(session()->get('role') == 1){
            $perpus_jurusan         = $this->mPerpusJurusan->where('id', $id)->first();
        }else if(session()->get('role') == 2){
            $perpus_jurusan         = $this->mPerpusJurusan->where('id', $id)->where('idPSekolah', session()->get('idPSekolah'))->first();
        }

        if (!$perpus_jurusan) {
            abort(404);
        }

        $data = [
            'title'             => $this->title,
            'url'               => $this->url,
            'url2'               => $this->url2,
            'page'              => 'Detail Data Jurusan',
            'id'                => $id,
            'perpus_jurusan'    => $perpus_jurusan,
        ];
        return view($this->views . "/show", $data);
    }

    public function edit($id)
    {
        if(session()->get('role') == 1){
            $perpus_jurusan      = $this->mPerpusJurusan->where('id', $id)->first();
        }else if(session()->get('role') == 2){
            $sekolah = [];
            $perpus_jurusan      = $this->mPerpusJurusan->where('id', $id)->where('idPSekolah', session()->get('idPSekolah'))->first();
        }

        $data = [
            'title'             => $this->title,
            'url'               => $this->url,
            'page'              => 'Edit Data Jurusan',
            'id'                => $id,
            'perpus_jurusan'    => $perpus_jurusan,
        ];
        return view($this->views . "/edit", $data);
    }

    public function update(Request $request, $id)
    {
        // Validasi
        $request->validate([
            'nama'        => 'required',
        ]);

        if(session()->get('role') == 1){
            $this->mPerpusJurusan->where('id', $id)->update(['nama' => $request->nama]);
        }else if(session()->get('role') == 2){
            $this->mPerpusJurusan->where('id', $id)->where('idPSekolah', session()->get('idPSekolah'))->update(['nama' => $request->nama]);
        }

        // Response
        return redirect("$this->url")->with('sukses', 'Data Jurusan berhasil di edit');
    }

    public function delete($id)
    {   
        try {

            if(session()->get('role') == 1){
                $this->mPerpusJurusan->where('id', $id)->delete();
                $this->mPerpusKelas->where('idPJurusan', $id)->delete();
                $this->mPerpusKelasKode->where('idPJurusan', $id)->delete();
            }else if(session()->get('role') == 2){
                $this->mPerpusJurusan->where('id', $id)->where('idPSekolah', session()->get('idPSekolah'))->delete();
                $this->mPerpusKelas->where('idPJurusan', $id)->where('idPSekolah', session()->get('idPSekolah'))->delete();
                $this->mPerpusKelasKode->where('idPJurusan', $id)->where('idPSekolah', session()->get('idPSekolah'))->delete();
            }

            return redirect("$this->url")->with('sukses', 'Data jurusan beserta tingkat dan indeks kelas di dalamnya berhasil di hapus');
        
        }catch (\Exception $e) {
            DB::rollback();
            // error message
            return redirect("$this->url")->with('gagal', 'Terjadi error: '. $e->getMessage());
        }
    }
}
