<?php

namespace App\Http\Controllers\Admin\Perpus;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Hash;
use Str;

use App\Models\User\UserModel;
use App\Models\Perpus\SekolahModel;
use App\Models\Master\ProvinsiModel;
use App\Models\Master\PeriodeModel;
use App\Models\Log\LogUploadLogoModel;
use App\Models\Log\LogUploadKopModel;

class InfoController extends Controller
{
    private $views      = 'admin/perpus/info';
    private $url        = 'admin/master/sekolah/info';
    private $title      = 'Halaman Info';

public function __construct()
    {
        createLogActivity();
        $this->mUsers           = new UserModel();
        $this->mPerpusSekolah   = new SekolahModel();
        $this->mProvinsi        = new ProvinsiModel();
        $this->mPeriode         = new PeriodeModel();
        $this->mLogUploadLogo   = new LogUploadLogoModel();
        $this->mLogUploadKop    = new LogUploadKopModel();

    }

    public function index()
    {
        $sekolah = $this->mPerpusSekolah->where('id', session()->get('idPSekolah'))->first();

        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Info',
            'sekolahan'     => $sekolah,
        ];
        return view($this->views . "/index", $data);
    }

    public function edit($id)
    {
        // 
        $sekolah = $this->mPerpusSekolah->where('id', session()->get('idPSekolah'))->first();
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Edit Data Info',
            'id'            => $id,
            'sekolahan'     => $sekolah,
        ];
        return view($this->views . "/edit", $data);
    }

    public function update(Request $request, $id)
    {
        $validateData = $request->validate([
            'photo'                    => 'mimes:jpg,jpeg,png',
            'gambar'                   => 'mimes:jpg,jpeg,png'
        ],[
            // 'photo.required'           => 'Pilih file terlebih dahulu',
            // 'gambar.required'          => 'Pilih file terlebih dahulu',
            'photo.mimes'              => 'Format data harus jpg, jpeg, atau png',
            'gambar.mimes'             => 'Format data harus jpg, jpeg, atau png',
        ]);

        if (isset($request->photo)) {
            if ($request->hasFile('photo')) {
                $file       = $request->file('photo');
                $fileName   = Str::uuid()."-".time().".".$file->extension();
                // $file->move(public_path(). "/upload/logo_sekolah/", $fileName);
                $file->move( "upload/logo_sekolah/", $fileName);

                $logLogo = [
                    'idUser'    => session()->get('users_id'),
                    'img'       => $fileName
                ];
                $this->mLogUploadLogo->create($logLogo);
            }
        }

        if (isset($request->gambar)) {
            if ($request->hasFile('gambar')) {
                $file       = $request->file('gambar');
                $fileNama   = Str::uuid()."-".time().".".$file->extension();
                // $file->move(public_path(). "/upload/logo_sekolah/", $fileNama);
                $file->move( "upload/logo_gambar/", $fileNama);

                $logKop = [
                    'idUser'    => session()->get('users_id'),
                    'img'       => $fileNama
                ];
                $this->mLogUploadKop->create($logKop);
            }
        }

        $perpus_sekolah      = $this->mPerpusSekolah->where('id', session()->get('idPSekolah'))->first();

        $dataInfo = [
            'logo'          => $request->photo ? $fileName : $perpus_sekolah->logo,
            'logo_gambar'   => $request->gambar ? $fileNama : $perpus_sekolah->logo_gambar,
            // 'nama'          => $request->nama ?? $perpus_sekolah->nama,
            'alamat'        => $request->alamat ?? $perpus_sekolah->alamat,
            'telp'          => $request->telp ?? $perpus_sekolah->telp,
            'web'           => $request->web ?? $perpus_sekolah->web,
            'email'         => $request->email ?? $perpus_sekolah->email,
        ];
        $this->mPerpusSekolah->where('id', session()->get('idPSekolah'))->update($dataInfo);
        return redirect("$this->url")->with('sukses', 'Data Info berhasil di edit');
    }
}
