<?php

namespace App\Http\Controllers\Admin\Periode;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
// Panggil Nama file Model yang mau dipake
use App\Models\Siswa\SiswaModel;
use App\Models\Master\SiswaStatusModel;
use App\Models\Siswa\SiswaMutasiModel;
use App\Models\Perpus\KelasKodeModel;

class PeriodeSiswaKelasController extends Controller
{
    private $views      = 'admin/periode/periode_siswa/kelas';
    private $url        = 'admin/tahun-ajaran/siswa';
    private $title      = 'Halaman Tahun Ajaran Kelas Siswa';

public function __construct()
    {
        createLogActivity();
        // Di isi Construct
        $this->mSiswa               = new SiswaModel();
        $this->mSiswaStatus         = new SiswaStatusModel();
        $this->mSiswaMutasi         = new SiswaMutasiModel();
        $this->mPerpusKelasKode     = new KelasKodeModel();
    }
    
    public function index()
    {
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Siswa Tentang Periode',
        ];
        return view($this->views . "/index", $data);
    }

    public function show($id)
    {
        $where = [
            // 'idPSekolah'    => session()->get('idPSekolah'),
            'idPPKelas'     => 0,
            'idPKKode'      => $id,
            'idMStatus'     => 1, // only stauts yang aktif yang bisa diubah. yang udah lulus keluar dll tidak bisa dirubah
        ];
        $siswa = $this->mSiswa->where($where)->get();

        if(count($siswa) == 0){
            return redirect("$this->url")->with('gagal', 'Tidak Ada Data yang bisa di Ubah');
        }else{
            $siswaStatus = $this->mSiswaStatus->get();
            $kelasSkr = $this->mPerpusKelasKode->where('id', $id)->first();
            $kelas = $this->mPerpusKelasKode->where('idPSekolah', session()->get('idPSekolah'))->get();
    
            $data = [
                'title'         => $this->title,
                'url'           => $this->url,
                'page'          => 'Update Data Kelas Siswa',
                'siswa'         => $siswa,
                'siswaStatus'   => $siswaStatus,
                'kelasSkr'         => $kelasSkr,
                'kelas'         => $kelas
            ];
    
            return view($this->views . "/edit", $data);
        }
    }

    public function update(Request $request, $id)
    {
        // 
        for($i=0; $i<count($request->idSiswa); $i++){
            $dataSiswa = [
                // 'idSiswa'       => $request->idSiswa[$i],
                'idPKKode'      => $request->idKelas[$i],
                'idMStatus'     => $request->idStatus[$i],
                'idPPkelas'     => 1,
                'idPPStatus'    => 1, // kalo mau gag sekalian statusnya bisa di hapus. kalo ini otomatis mhs aktif
            ];
            $this->mSiswa->where('id', $request->idSiswa[$i])->update($dataSiswa);
            // $data[] = $dataSiswa;

            // tambah mutasi
            $dataSiswaMutasi = [
                'idSiswa'       => $request->idSiswa[$i],
                'idPKKode'      => $request->idKelas[$i],
                'idPPeriode'    => session()->get('idPPeriode'),
                'idMStatus'     => $request->idStatus[$i],
            ];
            $this->mSiswaMutasi->create($dataSiswaMutasi);
        }

        return redirect("$this->url")->with('sukses', 'Data '.count($request->idSiswa).' Siswa berhasil di Update Sesuai Periode');
    }
}
