<?php

//redirect ke folder
namespace App\Http\Controllers\Admin\Periode;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Models\Perpus\SekolahModel;
use App\Models\Master\PeriodeModel;
use App\Models\Siswa\SiswaModel;
use App\Models\Perpus\KelasKodeModel;
use App\Models\User\UserModel;

class PeriodeController extends Controller
{
    private $views      = 'admin/periode/periode';
    private $url        = 'admin/tahun-ajaran';
    private $title      = 'Halaman Data Tahun Ajaran';

public function __construct()
    {
        createLogActivity();
        $this->mPerpusSekolah       = new SekolahModel();
        $this->mPerpusPeriode       = new PeriodeModel();
        $this->mSiswa               = new SiswaModel();
        $this->mPerpusKelasKode     = new KelasKodeModel();
        $this->mUsers               = new Usermodel();
    }

    public function index()
    {
        // $periode = $this->mPerpusPeriode->where('id', session()->get('idPPeriode'))->first();
        $sekolah = $this->mPerpusSekolah->where('id', session()->get('idPSekolah'))->first();

        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Tahun Ajaran',
            'sekolahan'     => $sekolah,
        ];

        return view($this->views . "/index", $data);
    }

    public function create()
    {
        $periode = $this->mPerpusPeriode->get();

        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Ubah Data Tahun Ajaran',
            'periode'       => $periode,
        ];

        return view($this->views . "/create", $data);
    }

    public function store(Request $request)
    {
        // if periode yang sekarang ditolak
        if($request->idPPeriode == session()->get('idPPeriode')){
            return redirect("$this->url")->with('gagal', 'Data Tahun Ajaran tidak berubah karena Tahun Ajaran yang dipilih adalah Tahun Ajaran sekarang');
        }
        else{
            // update perpus sekolah
            $dataPeriode = [
                'idPPeriode'        => $request->idPPeriode,
            ];
            $this->mPerpusSekolah->where('id', session()->get('idPSekolah'))->update($dataPeriode);
            $this->mUsers->where('idPSekolah', session()->get('idPSekolah'))->update($dataPeriode);

            $kelasKode = $this->mPerpusKelasKode->where('idPSekolah', session()->get('idPSekolah'))->pluck('id')->toArray();

            // reset siswa
            $dataSiswa = [
                'idPPeriode'        => $request->idPPeriode,
                'idPPkelas'         => 0,
                'idPPStatus'        => 0,
            ];
            $this->mSiswa->whereIn('idPKKode', $kelasKode)->where('idMStatus', 1)->update($dataSiswa);

            // reset wali kelas
            $this->mPerpusKelasKode->where('idPSekolah', session()->get('idPSekolah'))->update(['idSWali' => 0]);
            
            session()->flush();
            return redirect('login')->with('gagal', 'Data Tahun Ajaran berhasil di ganti, seluruh siswa harus diperbarui Kelasnya dan Statusnya dan seluruh kelas harus diperbarui Wali Kelasnya');
        }
    }
}
