<?php

namespace App\Http\Controllers\Admin\Master;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
// Panggil Nama file Model yang mau dipake
use App\Models\Master\PekerjaanModel;

class PekerjaanController extends Controller
{
    
    private $views      = 'admin/master/pekerjaan';
    
    // 
    private $url        = 'admin/master/pekerjaan';
    private $title      = 'Halaman Pekerjaan';


public function __construct()
    {
        createLogActivity();
        // Di isi Construct
        $this->mPekerjaan = New PekerjaanModel();
    
    }

    public function index()
    {
        $pekerjaan = $this->mPekerjaan->get();

        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Master Pekerjaan',

            //untuk memanggil data pekerjaan
            'pekerjaan'     => $pekerjaan
        ];
        return view($this->views . "/index", $data);
    }

    public function create()
    {
        
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Tambah Data Master Pekerjaan',
        ];
        return view($this->views . "/create", $data);
    }

    public function store(Request $request)
    {

        $dataPekerjaan = [
            'nama'      => $request->nama,
        ];
        $this->mPekerjaan->create($dataPekerjaan);

        return redirect("$this->url")->with('sukses', 'Pekerjaan berhasil di tambahkan');
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        // Get Data
        $pekerjaan      = $this->mPekerjaan->where('id', $id)->first();

        $data = [
            'title'     => $this->title,
            'url'       => $this->url,
            'page'      => 'Edit Data Pekerjaan',
            'id'        => $id,
            'pekerjaan'     => $pekerjaan,
        ];
        return view($this->views . "/edit", $data);
    }

    public function update(Request $request, $id)
    {
        // Validasi
        $request->validate([
            'id' => 'required',
            'nama' => 'required',
        ]);
        
        $dataPekerjaan = [
                'nama'      => $request->nama,
            ];
        $this->mPekerjaan->where('id', $request->id)->update($dataPekerjaan);

        // Response
        return redirect("$this->url")->with('sukses', 'Data Pekerjaan berhasil di edit');
    }

    public function destroy($id)
    {
        //
    }
}


