<?php

namespace App\Http\Controllers\Admin\Master;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use App\Models\Master\MapelGuruModel;

class MapelGuruController extends Controller
{
    private $views      = 'admin/master/mapel/guru';
    private $url        = 'admin/master/mapel-guru';
    private $title      = 'Halaman Master Mata Pelajaran Guru';


public function __construct()
    {
        createLogActivity();
        // Di isi Construct
        $this->mMapelGuru = New MapelGuruModel();
    }

    public function index()
    {
        $mapel = $this->mMapelGuru->get();

        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Master Mata Pelajaran Guru',
            'mapel'         => $mapel
        ];

        return view($this->views . "/index", $data);
    }

    public function create()
    {
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Tambah Data Master Mata Pelajaran Guru',
        ];
        
        return view($this->views . "/create", $data);
    }

    public function store(Request $request)
    {
        $dataMapel = [
            'nama'      => $request->nama,
        ];
        $this->mMapelGuru->create($dataMapel);

        return redirect("$this->url")->with('sukses', 'Mata Pelajaran Guru berhasil di tambahkan');
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        // Get Data
        $mapel          = $this->mMapelGuru->where('id', $id)->first();

        $data = [
            'title'     => $this->title,
            'url'       => $this->url,
            'page'      => 'Edit Data Mata Pelajaran Guru',
            'id'        => $id,
            'mapel'     => $mapel,
        ];
        return view($this->views . "/edit", $data);
    }

    public function update(Request $request, $id)
    {
        // Validasi
        $request->validate([
            'nama' => 'required',
        ]);
        
        $dataMapel = [
                'nama'      => $request->nama,
            ];
        $this->mMapelGuru->where('id', $id)->update($dataMapel);

        return redirect("$this->url")->with('sukses', 'Data Mata Pelajaran Guru');
    }

    public function destroy($id)
    {
        //
    }
}
