<?php

namespace App\Http\Controllers\Admin\Master;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;

use App\Models\Master\DaerahModel;
use App\Models\Master\ProvinsiModel;

class DaerahController extends Controller
{
    private $views      = 'admin/master/daerah';
    private $url        = 'admin/master/daerah';
    private $title      = 'Halaman Master Daerah';

public function __construct()
    {
        createLogActivity();
        $this->mDaerah         = new DaerahModel();
        $this->mProvinsi         = new ProvinsiModel();
    
    }

    public function index()
    {
        $daerah = $this->mDaerah->get();
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Master Daerah',
            'daerah'          => $daerah,
        ];

        // View, menuju file index di dalam folder = admin/mDaerah
        return view($this->views . "/index", $data);
    }

    public function create()
    {
        $provinsi = $this->mProvinsi->get();

        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Tambah Data Master Daerah',
            'provinsi'      => $provinsi,
        ];

        // View, menuju file index di dalam folder = admin/mDaerah
        return view($this->views . "/create", $data);
    }

    public function store(Request $request)
    {

        $dataDaerah = [
            'idMProvinsi'      => $request->idMProvinsi,
            'nama'      => $request->nama,
        ];
        $this->mDaerah->create($dataDaerah);

        return redirect("$this->url")->with('sukses', 'Daerah berhasil di tambahkan');
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        // Get Data
        $daerah      = $this->mDaerah->where('id', $id)->first();
        $provinsi = $this->mProvinsi->get();

        $data = [
            'title'     => $this->title,
            'url'       => $this->url,
            'page'      => 'Edit Data Daerah',
            'id'        => $id,
            'daerah'    => $daerah,
            'provinsi'  => $provinsi,
        ];
        return view($this->views . "/edit", $data);
    }

    public function update(Request $request, $id)
    {
        // Validasi
        $request->validate([
            'id'          => 'required',
            'idMProvinsi' => 'required',
            'nama'        => 'required',
        ]);
        
        $dataDaerah = [
                'idMProvinsi'=> $request->idMProvinsi,
                'nama'      => $request->nama,
            ];
        $this->mDaerah->where('id', $request->id)->update($dataDaerah);

        // Response
        return redirect("$this->url")->with('sukses', 'Data Daerah berhasil di edit');
    }

    public function destroy($id)
    {
        //
    }
}
