<?php

namespace App\Http\Controllers\Admin\Master;
use App\Http\Controllers\Controller;

use Illuminate\Http\Request;
use App\Models\Master\AgamaModel;

class AgamaController extends Controller
{
    

    private $views      = 'admin/master/agama';
    private $url        = 'admin/master/agama';
    private $title      = 'Halaman Agama';


public function __construct()
    {
        createLogActivity();
        // Di isi Construct
        $this->mAgama = New AgamaModel();
    }

    public function index()
    {
        $agama = $this->mAgama->get();

        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Data Master Agama',
            'agama'         => $agama
        ];

        return view($this->views . "/index", $data);
    }

    public function create()
    {
        $data = [
            'title'         => $this->title,
            'url'           => $this->url,
            'page'          => 'Tambah Data Master Agama',
        ];
        
        return view($this->views . "/create", $data);
    }

    public function store(Request $request)
    {
        $dataAgama = [
            'nama'      => $request->nama,
        ];
        $this->mAgama->create($dataAgama);

        return redirect("$this->url")->with('sukses', 'Agama berhasil di tambahkan');
    }

    public function show($id)
    {
        //
    }

    public function edit($id)
    {
        // Get Data
        $agama          = $this->mAgama->where('id', $id)->first();

        $data = [
            'title'     => $this->title,
            'url'       => $this->url,
            'page'      => 'Edit Data Agama',
            'id'        => $id,
            'agama'     => $agama,
        ];
        return view($this->views . "/edit", $data);
    }

    public function update(Request $request, $id)
    {
        // Validasi
        $request->validate([
            'nama' => 'required',
        ]);
        
        $dataAgama = [
                'nama'      => $request->nama,
            ];
        $this->mAgama->where('id', $id)->update($dataAgama);

        return redirect("$this->url")->with('sukses', 'Data Agama berhasil di edit');
    }

    public function destroy($id)
    {
        //
    }
}
